/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionRules;
import org.gradle.internal.Actions;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.CollectionUtils;

@ServiceScope(value={Scope.Project.class})
public class GlobalDependencyResolutionRules {
    private final DependencySubstitutionRules compositeRule;

    @Inject
    public GlobalDependencyResolutionRules(List<DependencySubstitutionRules> ruleProviders) {
        this.compositeRule = new CompositeSubstitutionRules(ruleProviders);
    }

    public DependencySubstitutionRules getDependencySubstitutionRules() {
        return this.compositeRule;
    }

    private static class CompositeSubstitutionRules
    implements DependencySubstitutionRules {
        private final List<DependencySubstitutionRules> ruleProviders;

        @Inject
        public CompositeSubstitutionRules(List<DependencySubstitutionRules> ruleProviders) {
            this.ruleProviders = ruleProviders;
        }

        @Override
        public Action<DependencySubstitution> getRuleAction() {
            return Actions.composite((List)CollectionUtils.collect(this.ruleProviders, DependencySubstitutionRules::getRuleAction));
        }

        @Override
        public boolean rulesMayAddProjectDependency() {
            for (DependencySubstitutionRules ruleProvider : this.ruleProviders) {
                if (!ruleProvider.rulesMayAddProjectDependency()) continue;
                return true;
            }
            return false;
        }
    }
}

