/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.dpop.verifiers;

import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPIssuer;
import com.nimbusds.oauth2.sdk.id.JWTID;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class DPoPProofUse {
    private final DPoPIssuer iss;
    private final JWTID jti;
    private final long maxAge;

    public DPoPProofUse(DPoPIssuer iss, JWTID jti, long maxAge) {
        this.jti = Objects.requireNonNull(jti);
        this.iss = Objects.requireNonNull(iss);
        if (maxAge < 0L) {
            throw new IllegalArgumentException("The DPoP proof max age must be non-negative");
        }
        this.maxAge = maxAge;
    }

    public DPoPIssuer getIssuer() {
        return this.iss;
    }

    public JWTID getJWTID() {
        return this.jti;
    }

    public long getMaxAge() {
        return this.maxAge;
    }
}

