﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/neptunedata/Neptunedata_EXPORTS.h>
#include <aws/neptunedata/NeptunedataRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace neptunedata
{
namespace Model
{

  /**
   */
  class CreateMLEndpointRequest : public NeptunedataRequest
  {
  public:
    AWS_NEPTUNEDATA_API CreateMLEndpointRequest() = default;

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "CreateMLEndpoint"; }

    AWS_NEPTUNEDATA_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>A unique identifier for the new inference endpoint. The default is an
     * autogenerated timestamped name.</p>
     */
    inline const Aws::String& GetId() const { return m_id; }
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
    template<typename IdT = Aws::String>
    void SetId(IdT&& value) { m_idHasBeenSet = true; m_id = std::forward<IdT>(value); }
    template<typename IdT = Aws::String>
    CreateMLEndpointRequest& WithId(IdT&& value) { SetId(std::forward<IdT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The job Id of the completed model-training job that has created the model
     * that the inference endpoint will point to. You must supply either the
     * <code>mlModelTrainingJobId</code> or the <code>mlModelTransformJobId</code>.</p>
     */
    inline const Aws::String& GetMlModelTrainingJobId() const { return m_mlModelTrainingJobId; }
    inline bool MlModelTrainingJobIdHasBeenSet() const { return m_mlModelTrainingJobIdHasBeenSet; }
    template<typename MlModelTrainingJobIdT = Aws::String>
    void SetMlModelTrainingJobId(MlModelTrainingJobIdT&& value) { m_mlModelTrainingJobIdHasBeenSet = true; m_mlModelTrainingJobId = std::forward<MlModelTrainingJobIdT>(value); }
    template<typename MlModelTrainingJobIdT = Aws::String>
    CreateMLEndpointRequest& WithMlModelTrainingJobId(MlModelTrainingJobIdT&& value) { SetMlModelTrainingJobId(std::forward<MlModelTrainingJobIdT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The job Id of the completed model-transform job. You must supply either the
     * <code>mlModelTrainingJobId</code> or the <code>mlModelTransformJobId</code>.</p>
     */
    inline const Aws::String& GetMlModelTransformJobId() const { return m_mlModelTransformJobId; }
    inline bool MlModelTransformJobIdHasBeenSet() const { return m_mlModelTransformJobIdHasBeenSet; }
    template<typename MlModelTransformJobIdT = Aws::String>
    void SetMlModelTransformJobId(MlModelTransformJobIdT&& value) { m_mlModelTransformJobIdHasBeenSet = true; m_mlModelTransformJobId = std::forward<MlModelTransformJobIdT>(value); }
    template<typename MlModelTransformJobIdT = Aws::String>
    CreateMLEndpointRequest& WithMlModelTransformJobId(MlModelTransformJobIdT&& value) { SetMlModelTransformJobId(std::forward<MlModelTransformJobIdT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>If set to <code>true</code>, <code>update</code> indicates that this is an
     * update request. The default is <code>false</code>. You must supply either the
     * <code>mlModelTrainingJobId</code> or the <code>mlModelTransformJobId</code>.</p>
     */
    inline bool GetUpdate() const { return m_update; }
    inline bool UpdateHasBeenSet() const { return m_updateHasBeenSet; }
    inline void SetUpdate(bool value) { m_updateHasBeenSet = true; m_update = value; }
    inline CreateMLEndpointRequest& WithUpdate(bool value) { SetUpdate(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ARN of an IAM role providing Neptune access to SageMaker and Amazon S3
     * resources. This must be listed in your DB cluster parameter group or an error
     * will be thrown.</p>
     */
    inline const Aws::String& GetNeptuneIamRoleArn() const { return m_neptuneIamRoleArn; }
    inline bool NeptuneIamRoleArnHasBeenSet() const { return m_neptuneIamRoleArnHasBeenSet; }
    template<typename NeptuneIamRoleArnT = Aws::String>
    void SetNeptuneIamRoleArn(NeptuneIamRoleArnT&& value) { m_neptuneIamRoleArnHasBeenSet = true; m_neptuneIamRoleArn = std::forward<NeptuneIamRoleArnT>(value); }
    template<typename NeptuneIamRoleArnT = Aws::String>
    CreateMLEndpointRequest& WithNeptuneIamRoleArn(NeptuneIamRoleArnT&& value) { SetNeptuneIamRoleArn(std::forward<NeptuneIamRoleArnT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Model type for training. By default the Neptune ML model is automatically
     * based on the <code>modelType</code> used in data processing, but you can specify
     * a different model type here. The default is <code>rgcn</code> for heterogeneous
     * graphs and <code>kge</code> for knowledge graphs. The only valid value for
     * heterogeneous graphs is <code>rgcn</code>. Valid values for knowledge graphs
     * are: <code>kge</code>, <code>transe</code>, <code>distmult</code>, and
     * <code>rotate</code>.</p>
     */
    inline const Aws::String& GetModelName() const { return m_modelName; }
    inline bool ModelNameHasBeenSet() const { return m_modelNameHasBeenSet; }
    template<typename ModelNameT = Aws::String>
    void SetModelName(ModelNameT&& value) { m_modelNameHasBeenSet = true; m_modelName = std::forward<ModelNameT>(value); }
    template<typename ModelNameT = Aws::String>
    CreateMLEndpointRequest& WithModelName(ModelNameT&& value) { SetModelName(std::forward<ModelNameT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The type of Neptune ML instance to use for online servicing. The default is
     * <code>ml.m5.xlarge</code>. Choosing the ML instance for an inference endpoint
     * depends on the task type, the graph size, and your budget.</p>
     */
    inline const Aws::String& GetInstanceType() const { return m_instanceType; }
    inline bool InstanceTypeHasBeenSet() const { return m_instanceTypeHasBeenSet; }
    template<typename InstanceTypeT = Aws::String>
    void SetInstanceType(InstanceTypeT&& value) { m_instanceTypeHasBeenSet = true; m_instanceType = std::forward<InstanceTypeT>(value); }
    template<typename InstanceTypeT = Aws::String>
    CreateMLEndpointRequest& WithInstanceType(InstanceTypeT&& value) { SetInstanceType(std::forward<InstanceTypeT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The minimum number of Amazon EC2 instances to deploy to an endpoint for
     * prediction. The default is 1</p>
     */
    inline int GetInstanceCount() const { return m_instanceCount; }
    inline bool InstanceCountHasBeenSet() const { return m_instanceCountHasBeenSet; }
    inline void SetInstanceCount(int value) { m_instanceCountHasBeenSet = true; m_instanceCount = value; }
    inline CreateMLEndpointRequest& WithInstanceCount(int value) { SetInstanceCount(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to
     * encrypt data on the storage volume attached to the ML compute instances that run
     * the training job. The default is None.</p>
     */
    inline const Aws::String& GetVolumeEncryptionKMSKey() const { return m_volumeEncryptionKMSKey; }
    inline bool VolumeEncryptionKMSKeyHasBeenSet() const { return m_volumeEncryptionKMSKeyHasBeenSet; }
    template<typename VolumeEncryptionKMSKeyT = Aws::String>
    void SetVolumeEncryptionKMSKey(VolumeEncryptionKMSKeyT&& value) { m_volumeEncryptionKMSKeyHasBeenSet = true; m_volumeEncryptionKMSKey = std::forward<VolumeEncryptionKMSKeyT>(value); }
    template<typename VolumeEncryptionKMSKeyT = Aws::String>
    CreateMLEndpointRequest& WithVolumeEncryptionKMSKey(VolumeEncryptionKMSKeyT&& value) { SetVolumeEncryptionKMSKey(std::forward<VolumeEncryptionKMSKeyT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_id;
    bool m_idHasBeenSet = false;

    Aws::String m_mlModelTrainingJobId;
    bool m_mlModelTrainingJobIdHasBeenSet = false;

    Aws::String m_mlModelTransformJobId;
    bool m_mlModelTransformJobIdHasBeenSet = false;

    bool m_update{false};
    bool m_updateHasBeenSet = false;

    Aws::String m_neptuneIamRoleArn;
    bool m_neptuneIamRoleArnHasBeenSet = false;

    Aws::String m_modelName;
    bool m_modelNameHasBeenSet = false;

    Aws::String m_instanceType;
    bool m_instanceTypeHasBeenSet = false;

    int m_instanceCount{0};
    bool m_instanceCountHasBeenSet = false;

    Aws::String m_volumeEncryptionKMSKey;
    bool m_volumeEncryptionKMSKeyHasBeenSet = false;
  };

} // namespace Model
} // namespace neptunedata
} // namespace Aws
