# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "security contact update",
    is_preview=True,
)
class Update(AAZCommand):
    """Update security contact configurations for the subscription

    :example: Updates a security contact.
        az security contact update -n 'default' --emails 'john1@contoso.com;jane@contoso.com' --phone '214-275-4038' --notifications-by-role '{"state":"On","roles":["Owner"]}' --alert-notifications '{"state":"On","minimalSeverity":"Low"}'
    """

    _aaz_info = {
        "version": "2020-01-01-preview",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.security/securitycontacts/{}", "2020-01-01-preview"],
        ]
    }

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.security_contact_name = AAZStrArg(
            options=["-n", "--name", "--security-contact-name"],
            help="Name of the security contact object",
            required=True,
            id_part="name",
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.alert_notifications = AAZObjectArg(
            options=["--alert-notifications"],
            arg_group="Properties",
            help="Defines whether to send email notifications about new security alerts",
            nullable=True,
        )
        _args_schema.emails = AAZStrArg(
            options=["--emails"],
            arg_group="Properties",
            help="List of email addresses which will get notifications from Microsoft Defender for Cloud by the configurations defined in this security contact.",
            nullable=True,
        )
        _args_schema.notifications_by_role = AAZObjectArg(
            options=["--notifications-by-role"],
            arg_group="Properties",
            help="Defines whether to send email notifications from Microsoft Defender for Cloud to persons with specific RBAC roles on the subscription.",
            nullable=True,
        )
        _args_schema.phone = AAZStrArg(
            options=["--phone"],
            arg_group="Properties",
            help="The security contact's phone number",
            nullable=True,
        )

        alert_notifications = cls._args_schema.alert_notifications
        alert_notifications.minimal_severity = AAZStrArg(
            options=["minimal-severity"],
            help="Defines the minimal alert severity which will be sent as email notifications",
            nullable=True,
            enum={"High": "High", "Low": "Low", "Medium": "Medium"},
        )
        alert_notifications.state = AAZStrArg(
            options=["state"],
            help="Defines if email notifications will be sent about new security alerts",
            nullable=True,
            enum={"Off": "Off", "On": "On"},
        )

        notifications_by_role = cls._args_schema.notifications_by_role
        notifications_by_role.roles = AAZListArg(
            options=["roles"],
            help="Defines which RBAC roles will get email notifications from Microsoft Defender for Cloud. List of allowed RBAC roles: ",
            nullable=True,
        )
        notifications_by_role.state = AAZStrArg(
            options=["state"],
            help="Defines whether to send email notifications from AMicrosoft Defender for Cloud to persons with specific RBAC roles on the subscription.",
            nullable=True,
            enum={"Off": "Off", "On": "On"},
        )

        roles = cls._args_schema.notifications_by_role.roles
        roles.Element = AAZStrArg(
            nullable=True,
            enum={"AccountAdmin": "AccountAdmin", "Contributor": "Contributor", "Owner": "Owner", "ServiceAdmin": "ServiceAdmin"},
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.SecurityContactsGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        self.SecurityContactsCreate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class SecurityContactsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.Security/securityContacts/{securityContactName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "securityContactName", self.ctx.args.security_contact_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2020-01-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_security_contact_read(cls._schema_on_200)

            return cls._schema_on_200

    class SecurityContactsCreate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200, 201]:
                return self.on_200_201(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.Security/securityContacts/{securityContactName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "securityContactName", self.ctx.args.security_contact_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2020-01-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _UpdateHelper._build_schema_security_contact_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("alertNotifications", AAZObjectType, ".alert_notifications")
                properties.set_prop("emails", AAZStrType, ".emails")
                properties.set_prop("notificationsByRole", AAZObjectType, ".notifications_by_role")
                properties.set_prop("phone", AAZStrType, ".phone")

            alert_notifications = _builder.get(".properties.alertNotifications")
            if alert_notifications is not None:
                alert_notifications.set_prop("minimalSeverity", AAZStrType, ".minimal_severity")
                alert_notifications.set_prop("state", AAZStrType, ".state")

            notifications_by_role = _builder.get(".properties.notificationsByRole")
            if notifications_by_role is not None:
                notifications_by_role.set_prop("roles", AAZListType, ".roles")
                notifications_by_role.set_prop("state", AAZStrType, ".state")

            roles = _builder.get(".properties.notificationsByRole.roles")
            if roles is not None:
                roles.set_elements(AAZStrType, ".")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    _schema_security_contact_read = None

    @classmethod
    def _build_schema_security_contact_read(cls, _schema):
        if cls._schema_security_contact_read is not None:
            _schema.id = cls._schema_security_contact_read.id
            _schema.name = cls._schema_security_contact_read.name
            _schema.properties = cls._schema_security_contact_read.properties
            _schema.type = cls._schema_security_contact_read.type
            return

        cls._schema_security_contact_read = _schema_security_contact_read = AAZObjectType()

        security_contact_read = _schema_security_contact_read
        security_contact_read.id = AAZStrType(
            flags={"read_only": True},
        )
        security_contact_read.name = AAZStrType(
            flags={"read_only": True},
        )
        security_contact_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        security_contact_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_security_contact_read.properties
        properties.alert_notifications = AAZObjectType(
            serialized_name="alertNotifications",
        )
        properties.emails = AAZStrType()
        properties.notifications_by_role = AAZObjectType(
            serialized_name="notificationsByRole",
        )
        properties.phone = AAZStrType()

        alert_notifications = _schema_security_contact_read.properties.alert_notifications
        alert_notifications.minimal_severity = AAZStrType(
            serialized_name="minimalSeverity",
        )
        alert_notifications.state = AAZStrType()

        notifications_by_role = _schema_security_contact_read.properties.notifications_by_role
        notifications_by_role.roles = AAZListType()
        notifications_by_role.state = AAZStrType()

        roles = _schema_security_contact_read.properties.notifications_by_role.roles
        roles.Element = AAZStrType()

        _schema.id = cls._schema_security_contact_read.id
        _schema.name = cls._schema_security_contact_read.name
        _schema.properties = cls._schema_security_contact_read.properties
        _schema.type = cls._schema_security_contact_read.type


__all__ = ["Update"]
