/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.ToolMetadata;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.transport.tools.MLListToolsAction;
import org.opensearch.ml.common.transport.tools.MLToolsListRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLListToolsAction
extends BaseRestHandler {
    private static final String ML_LIST_TOOLS_ACTION = "ml_list_tools_action";
    private Map<String, Tool.Factory> toolFactories;

    public RestMLListToolsAction(Map<String, Tool.Factory> toolFactories) {
        this.toolFactories = toolFactories;
    }

    public String getName() {
        return ML_LIST_TOOLS_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/tools", "/_plugins/_ml")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLToolsListRequest mlToolsListRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLListToolsAction.INSTANCE, (ActionRequest)mlToolsListRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLToolsListRequest getRequest(RestRequest request) throws IOException {
        ArrayList toolList = new ArrayList();
        this.toolFactories.forEach((key, value) -> toolList.add(ToolMetadata.builder().name(key).description(value.getDefaultDescription()).type(value.getDefaultType()).version(value.getDefaultVersion()).attributes(value.getDefaultAttributes()).build()));
        MLToolsListRequest mlToolsGetRequest = MLToolsListRequest.builder().toolMetadataList(toolList).build();
        return mlToolsGetRequest;
    }
}

