/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.services.kms.internaldafny.types;

import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.services.kms.internaldafny.types.CiphertextType;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptionAlgorithmSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.KeyIdType;
import software.amazon.cryptography.services.kms.internaldafny.types.PlaintextType;

public class DecryptResponse {
    public Option<DafnySequence<? extends Character>> _KeyId;
    public Option<DafnySequence<? extends Byte>> _Plaintext;
    public Option<EncryptionAlgorithmSpec> _EncryptionAlgorithm;
    public Option<DafnySequence<? extends Byte>> _CiphertextForRecipient;
    private static final TypeDescriptor<DecryptResponse> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptResponse.class, () -> DecryptResponse.Default());
    private static final DecryptResponse theDefault = DecryptResponse.create(Option.Default(KeyIdType._typeDescriptor()), Option.Default(PlaintextType._typeDescriptor()), Option.Default(EncryptionAlgorithmSpec._typeDescriptor()), Option.Default(CiphertextType._typeDescriptor()));

    public DecryptResponse(Option<DafnySequence<? extends Character>> KeyId, Option<DafnySequence<? extends Byte>> Plaintext, Option<EncryptionAlgorithmSpec> EncryptionAlgorithm, Option<DafnySequence<? extends Byte>> CiphertextForRecipient) {
        this._KeyId = KeyId;
        this._Plaintext = Plaintext;
        this._EncryptionAlgorithm = EncryptionAlgorithm;
        this._CiphertextForRecipient = CiphertextForRecipient;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        DecryptResponse o = (DecryptResponse)other;
        return Objects.equals(this._KeyId, o._KeyId) && Objects.equals(this._Plaintext, o._Plaintext) && Objects.equals(this._EncryptionAlgorithm, o._EncryptionAlgorithm) && Objects.equals(this._CiphertextForRecipient, o._CiphertextForRecipient);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._KeyId);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._Plaintext);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._EncryptionAlgorithm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._CiphertextForRecipient);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("ComAmazonawsKmsTypes.DecryptResponse.DecryptResponse");
        s.append("(");
        s.append(Helpers.toString(this._KeyId));
        s.append(", ");
        s.append(Helpers.toString(this._Plaintext));
        s.append(", ");
        s.append(Helpers.toString(this._EncryptionAlgorithm));
        s.append(", ");
        s.append(Helpers.toString(this._CiphertextForRecipient));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<DecryptResponse> _typeDescriptor() {
        return _TYPE;
    }

    public static DecryptResponse Default() {
        return theDefault;
    }

    public static DecryptResponse create(Option<DafnySequence<? extends Character>> KeyId, Option<DafnySequence<? extends Byte>> Plaintext, Option<EncryptionAlgorithmSpec> EncryptionAlgorithm, Option<DafnySequence<? extends Byte>> CiphertextForRecipient) {
        return new DecryptResponse(KeyId, Plaintext, EncryptionAlgorithm, CiphertextForRecipient);
    }

    public static DecryptResponse create_DecryptResponse(Option<DafnySequence<? extends Character>> KeyId, Option<DafnySequence<? extends Byte>> Plaintext, Option<EncryptionAlgorithmSpec> EncryptionAlgorithm, Option<DafnySequence<? extends Byte>> CiphertextForRecipient) {
        return DecryptResponse.create(KeyId, Plaintext, EncryptionAlgorithm, CiphertextForRecipient);
    }

    public boolean is_DecryptResponse() {
        return true;
    }

    public Option<DafnySequence<? extends Character>> dtor_KeyId() {
        return this._KeyId;
    }

    public Option<DafnySequence<? extends Byte>> dtor_Plaintext() {
        return this._Plaintext;
    }

    public Option<EncryptionAlgorithmSpec> dtor_EncryptionAlgorithm() {
        return this._EncryptionAlgorithm;
    }

    public Option<DafnySequence<? extends Byte>> dtor_CiphertextForRecipient() {
        return this._CiphertextForRecipient;
    }
}

