/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.spec.FPEParameterSpec;

class FPEParametersCreator<T extends ParametersWithIV>
implements ParametersCreator {
    private final FipsAES.FPEParameters baseParameters;

    FPEParametersCreator(FipsAES.FPEParameters fPEParameters) {
        this.baseParameters = fPEParameters;
    }

    public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof FPEParameterSpec) {
            return this.baseParameters.withRadixConverter(((FPEParameterSpec)algorithmParameterSpec).getRadixConverter()).withTweak(((FPEParameterSpec)algorithmParameterSpec).getTweak()).withUsingInverseFunction(((FPEParameterSpec)algorithmParameterSpec).isUsingInverseFunction());
        }
        throw new InvalidAlgorithmParameterException("paramspec required");
    }
}

