amber99_dict = {
'NHE': [
   (
      'N<0>([H]<1>)([H]<2>)',
      {
         0: ('N'   , 'N'   ,   -0.4630,    1.8240),
         1: ('HN1' , 'H'   ,    0.2315,    0.6000),
         2: ('HN2' , 'H'   ,    0.2315,    0.6000),
      },
   ),
],
'NME': [
   (
      'N<0>([H]<1>)[C@]<2>([H]<3>)([H]<4>)[H]<5>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CH3' , 'CT'  ,   -0.1490,    1.9080),
         3: ('HH31', 'HC'  ,    0.0976,    1.3870),
         4: ('HH32', 'HC'  ,    0.0976,    1.3870),
         5: ('HH33', 'HC'  ,    0.0976,    1.3870),

      },
   ),
],
'ACE': [
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([H]<4>)[H]<5>',
      {
         0: ('C'   , 'C'   ,    0.5972,    1.9080),
         1: ('O'   , 'O'   ,   -0.5679,    1.6612),
         2: ('CH3' , 'CT'  ,   -0.3662,    1.9080),
         3: ('HH31', 'HC'  ,    0.1123,    1.4870),
         4: ('HH32', 'HC'  ,    0.1123,    1.4870),
         5: ('HH33', 'HC'  ,    0.1123,    1.4870),
      },
   ),
],
'ALA': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@]<4>([H]<5>)([H]<6>)[H]<7>)C<8>=O<9>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,    0.0337,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0823,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.1825,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0603,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0603,    1.4870),
         7: ('HB1' , 'HC'  ,    0.0603,    1.4870),
         8: ('C'   , 'C'   ,    0.5973,    1.9080),
         9: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@]<4>([H]<5>)([H]<6>)[H]<7>)[N@+]<8>([H]<9>)([H]<10>)[H]<11>',
      {
         0: ('C'   , 'C'   ,    0.6163,    1.9080),
         1: ('O'   , 'O'   ,   -0.5722,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0962,    1.9080),
         3: ('HA'  , 'HP'  ,    0.0889,    1.1000),
         4: ('CB'  , 'CT'  ,   -0.0597,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0300,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0300,    1.4870),
         7: ('HB1' , 'HC'  ,    0.0300,    1.4870),
         8: ('N'   , 'N3'  ,    0.1414,    1.8240),
         9: ('H3'  , 'H'   ,    0.1997,    0.6000),
        10: ('H2'  , 'H'   ,    0.1997,    0.6000),
        11: ('H1'  , 'H'   ,    0.1997,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@]<4>([H]<5>)([H]<6>)[H]<7>)C<8>([O-]<9>)=O<10>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.1747,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1067,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.2093,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0764,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0764,    1.4870),
         7: ('HB1' , 'HC'  ,    0.0764,    1.4870),
         8: ('C'   , 'C'   ,    0.7731,    1.9080),
         9: ('OXT' , 'O2'  ,   -0.8055,    1.6612),
        10: ('O'   , 'O2'  ,   -0.8055,    1.6612),
      },
   ),
],
'ARG': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)[C@@]<10>([H]<11>)([H]<12>)N<13>([H]<14>)C<15>(N<16>([H]<17>)[H]<18>)=[N+]<19>([H]<20>)[H]<21>)C<22>=O<23>',
      {
         0: ('N'   , 'N'   ,   -0.3479,    1.8240),
         1: ('H'   , 'H'   ,    0.2747,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2637,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1560,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0007,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0327,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0327,    1.4870),
         7: ('CG'  , 'CT'  ,    0.0390,    1.9080),
         8: ('HG3' , 'HC'  ,    0.0285,    1.4870),
         9: ('HG2' , 'HC'  ,    0.0285,    1.4870),
        10: ('CD'  , 'CT'  ,    0.0486,    1.9080),
        11: ('HD3' , 'H1'  ,    0.0687,    1.3870),
        12: ('HD2' , 'H1'  ,    0.0687,    1.3870),
        13: ('NE'  , 'N2'  ,   -0.5295,    1.8240),
        14: ('HE'  , 'H'   ,    0.3456,    0.6000),
        15: ('CZ'  , 'CA'  ,    0.8076,    1.9080),
        16: ('NH2' , 'N2'  ,   -0.8627,    1.8240),
        17: ('HH22', 'H'   ,    0.4478,    0.6000),
        18: ('HH21', 'H'   ,    0.4478,    0.6000),
        19: ('NH1' , 'N2'  ,   -0.8627,    1.8240),
        20: ('HH12', 'H'   ,    0.4478,    0.6000),
        21: ('HH11', 'H'   ,    0.4478,    0.6000),
        22: ('C'   , 'C'   ,    0.7341,    1.9080),
        23: ('O'   , 'O'   ,   -0.5894,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)[C@@]<10>([H]<11>)([H]<12>)N<13>([H]<14>)C<15>(N<16>([H]<17>)[H]<18>)=[N+]<19>([H]<20>)[H]<21>)[N@+]<22>([H]<23>)([H]<24>)[H]<25>',
      {
         0: ('C'   , 'C'   ,    0.7214,    1.9080),
         1: ('O'   , 'O'   ,   -0.6013,    1.6612),
         2: ('CA'  , 'CT'  ,   -0.0223,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1242,    1.1000),
         4: ('CB'  , 'CT'  ,    0.0118,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0226,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0226,    1.4870),
         7: ('CG'  , 'CT'  ,    0.0236,    1.9080),
         8: ('HG3' , 'HC'  ,    0.0309,    1.4870),
         9: ('HG2' , 'HC'  ,    0.0309,    1.4870),
        10: ('CD'  , 'CT'  ,    0.0935,    1.9080),
        11: ('HD3' , 'H1'  ,    0.0527,    1.3870),
        12: ('HD2' , 'H1'  ,    0.0527,    1.3870),
        13: ('NE'  , 'N2'  ,   -0.5650,    1.8240),
        14: ('HE'  , 'H'   ,    0.3592,    0.6000),
        15: ('CZ'  , 'CA'  ,    0.8281,    1.9080),
        16: ('NH2' , 'N2'  ,   -0.8693,    1.8240),
        17: ('HH22', 'H'   ,    0.4494,    0.6000),
        18: ('HH21', 'H'   ,    0.4494,    0.6000),
        19: ('NH1' , 'N2'  ,   -0.8693,    1.8240),
        20: ('HH12', 'H'   ,    0.4494,    0.6000),
        21: ('HH11', 'H'   ,    0.4494,    0.6000),
        22: ('N'   , 'N3'  ,    0.1305,    1.8240),
        23: ('H3'  , 'H'   ,    0.2083,    0.6000),
        24: ('H2'  , 'H'   ,    0.2083,    0.6000),
        25: ('H1'  , 'H'   ,    0.2083,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)[C@@]<10>([H]<11>)([H]<12>)N<13>([H]<14>)C<15>(N<16>([H]<17>)[H]<18>)=[N+]<19>([H]<20>)[H]<21>)C<22>([O-]<23>)=O<24>',
      {
         0: ('N'   , 'N'   ,   -0.3481,    1.8240),
         1: ('H'   , 'H'   ,    0.2764,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.3068,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1447,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0374,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0371,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0371,    1.4870),
         7: ('CG'  , 'CT'  ,    0.0744,    1.9080),
         8: ('HG3' , 'HC'  ,    0.0185,    1.4870),
         9: ('HG2' , 'HC'  ,    0.0185,    1.4870),
        10: ('CD'  , 'CT'  ,    0.1114,    1.9080),
        11: ('HD3' , 'H1'  ,    0.0468,    1.3870),
        12: ('HD2' , 'H1'  ,    0.0468,    1.3870),
        13: ('NE'  , 'N2'  ,   -0.5564,    1.8240),
        14: ('HE'  , 'H'   ,    0.3479,    0.6000),
        15: ('CZ'  , 'CA'  ,    0.8368,    1.9080),
        16: ('NH2' , 'N2'  ,   -0.8737,    1.8240),
        17: ('HH22', 'H'   ,    0.4493,    0.6000),
        18: ('HH21', 'H'   ,    0.4493,    0.6000),
        19: ('NH1' , 'N2'  ,   -0.8737,    1.8240),
        20: ('HH12', 'H'   ,    0.4493,    0.6000),
        21: ('HH11', 'H'   ,    0.4493,    0.6000),
        22: ('C'   , 'C'   ,    0.8557,    1.9080),
        23: ('OXT' , 'O2'  ,   -0.8266,    1.6612),
        24: ('O'   , 'O2'  ,   -0.8266,    1.6612),
      },
   ),
],
'ASP': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>([O-]<8>)=O<9>)C<10>=O<11>',
      {
         0: ('N'   , 'N'   ,   -0.5163,    1.8240),
         1: ('H'   , 'H'   ,    0.2936,    0.6000),
         2: ('CA'  , 'CT'  ,    0.0381,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0880,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0303,    1.9080),
         5: ('HB3' , 'HC'  ,   -0.0122,    1.4870),
         6: ('HB2' , 'HC'  ,   -0.0122,    1.4870),
         7: ('CG'  , 'C'   ,    0.7994,    1.9080),
         8: ('OD2' , 'O2'  ,   -0.8014,    1.6612),
         9: ('OD1' , 'O2'  ,   -0.8014,    1.6612),
        10: ('C'   , 'C'   ,    0.5366,    1.9080),
        11: ('O'   , 'O'   ,   -0.5819,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>([O-]<8>)=O<9>)[N@+]<10>([H]<11>)([H]<12>)[H]<13>',
      {
         0: ('C'   , 'C'   ,    0.5621,    1.9080),
         1: ('O'   , 'O'   ,   -0.5889,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0292,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1141,    1.1000),
         4: ('CB'  , 'CT'  ,   -0.0235,    1.9080),
         5: ('HB3' , 'HC'  ,   -0.0169,    1.4870),
         6: ('HB2' , 'HC'  ,   -0.0169,    1.4870),
         7: ('CG'  , 'C'   ,    0.8194,    1.9080),
         8: ('OD2' , 'O2'  ,   -0.8084,    1.6612),
         9: ('OD1' , 'O2'  ,   -0.8084,    1.6612),
        10: ('N'   , 'N3'  ,    0.0782,    1.8240),
        11: ('H3'  , 'H'   ,    0.2200,    0.6000),
        12: ('H2'  , 'H'   ,    0.2200,    0.6000),
        13: ('H1'  , 'H'   ,    0.2200,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>([O-]<8>)=O<9>)C<10>([O-]<11>)=O<12>',
      {
         0: ('N'   , 'N'   ,   -0.5192,    1.8240),
         1: ('H'   , 'H'   ,    0.3055,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.1817,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1046,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0677,    1.9080),
         5: ('HB3' , 'HC'  ,   -0.0212,    1.4870),
         6: ('HB2' , 'HC'  ,   -0.0212,    1.4870),
         7: ('CG'  , 'C'   ,    0.8851,    1.9080),
         8: ('OD2' , 'O2'  ,   -0.8162,    1.6612),
         9: ('OD1' , 'O2'  ,   -0.8162,    1.6612),
        10: ('C'   , 'C'   ,    0.7256,    1.9080),
        11: ('OXT' , 'O2'  ,   -0.7887,    1.6612),
        12: ('O'   , 'O2'  ,   -0.7887,    1.6612),
      },
   ),
],
'ASN': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>(=O<8>)N<9>([H]<10>)[H]<11>)C<12>=O<13>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,    0.0143,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1048,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.2041,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0797,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0797,    1.4870),
         7: ('CG'  , 'C'   ,    0.7130,    1.9080),
         8: ('OD1' , 'O'   ,   -0.5931,    1.6612),
         9: ('ND2' , 'N'   ,   -0.9191,    1.8240),
        10: ('HD22', 'H'   ,    0.4196,    0.6000),
        11: ('HD21', 'H'   ,    0.4196,    0.6000),
        12: ('C'   , 'C'   ,    0.5973,    1.9080),
        13: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>(=O<8>)N<9>([H]<10>)[H]<11>)[N@+]<12>([H]<13>)([H]<14>)[H]<15>',
      {
         0: ('C'   , 'C'   ,    0.6163,    1.9080),
         1: ('O'   , 'O'   ,   -0.5722,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0368,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1231,    1.1000),
         4: ('CB'  , 'CT'  ,   -0.0283,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0515,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0515,    1.4870),
         7: ('CG'  , 'C'   ,    0.5833,    1.9080),
         8: ('OD1' , 'O'   ,   -0.5744,    1.6612),
         9: ('ND2' , 'N'   ,   -0.8634,    1.8240),
        10: ('HD22', 'H'   ,    0.4097,    0.6000),
        11: ('HD21', 'H'   ,    0.4097,    0.6000),
        12: ('N'   , 'N3'  ,    0.1801,    1.8240),
        13: ('H3'  , 'H'   ,    0.1921,    0.6000),
        14: ('H2'  , 'H'   ,    0.1921,    0.6000),
        15: ('H1'  , 'H'   ,    0.1921,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>(=O<8>)N<9>([H]<10>)[H]<11>)C<12>([O-]<13>)=O<14>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2080,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1358,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.2299,    1.9080),
         5: ('HB3' , 'HC'  ,    0.1023,    1.4870),
         6: ('HB2' , 'HC'  ,    0.1023,    1.4870),
         7: ('CG'  , 'C'   ,    0.7153,    1.9080),
         8: ('OD1' , 'O'   ,   -0.6010,    1.6612),
         9: ('ND2' , 'N'   ,   -0.9084,    1.8240),
        10: ('HD22', 'H'   ,    0.4150,    0.6000),
        11: ('HD21', 'H'   ,    0.4150,    0.6000),
        12: ('C'   , 'C'   ,    0.8050,    1.9080),
        13: ('OXT' , 'O2'  ,   -0.8147,    1.6612),
        14: ('O'   , 'O2'  ,   -0.8147,    1.6612),
      },
   ),
],
'CYS': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)S<7>[H]<8>)C<9>=O<10>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,    0.0213,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1124,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.1231,    1.9080),
         5: ('HB3' , 'H1'  ,    0.1112,    1.3870),
         6: ('HB2' , 'H1'  ,    0.1112,    1.3870),
         7: ('SG'  , 'SH'  ,   -0.3119,    2.0000),
         8: ('HG'  , 'HS'  ,    0.1933,    0.6000),
         9: ('C'   , 'C'   ,    0.5973,    1.9080),
        10: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)S<7>[H]<8>)[N@+]<9>([H]<10>)([H]<11>)[H]<12>',
      {
         0: ('C'   , 'C'   ,    0.6123,    1.9080),
         1: ('O'   , 'O'   ,   -0.5713,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0927,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1411,    1.1000),
         4: ('CB'  , 'CT'  ,   -0.1195,    1.9080),
         5: ('HB3' , 'H1'  ,    0.1188,    1.3870),
         6: ('HB2' , 'H1'  ,    0.1188,    1.3870),
         7: ('SG'  , 'SH'  ,   -0.3298,    2.0000),
         8: ('HG'  , 'HS'  ,    0.1975,    0.6000),
         9: ('N'   , 'N3'  ,    0.1325,    1.8240),
        10: ('H3'  , 'H'   ,    0.2023,    0.6000),
        11: ('H2'  , 'H'   ,    0.2023,    0.6000),
        12: ('H1'  , 'H'   ,    0.2023,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)S<7>[H]<8>)C<9>([O-]<10>)=O<11>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.1635,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1396,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.1996,    1.9080),
         5: ('HB3' , 'H1'  ,    0.1437,    1.3870),
         6: ('HB2' , 'H1'  ,    0.1437,    1.3870),
         7: ('SG'  , 'SH'  ,   -0.3102,    2.0000),
         8: ('HG'  , 'HS'  ,    0.2068,    0.6000),
         9: ('C'   , 'C'   ,    0.7497,    1.9080),
        10: ('OXT' , 'O2'  ,   -0.7981,    1.6612),
        11: ('O'   , 'O2'  ,   -0.7981,    1.6612),
      },
   ),
   ( # disulfide bonded
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)S<7>S<7>)C<9>=O<10>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,    0.0429,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0766,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0790,    1.9080),
         5: ('HB3' , 'H1'  ,    0.0910,    1.3870),
         6: ('HB2' , 'H1'  ,    0.0910,    1.3870),
         7: ('SG'  , 'S'   ,   -0.1081,    2.0000),
         9: ('C'   , 'C'   ,    0.5973,    1.9080),
        10: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)S<7>S<7>)[N@+]<9>([H]<10>)([H]<11>)[H]<12>',
      {
         0: ('C'   , 'C'   ,    0.6123,    1.9080),
         1: ('O'   , 'O'   ,   -0.5713,    1.6612),
         2: ('CA'  , 'CT'  ,    0.1055,    1.9080),
         3: ('HA'  , 'HP'  ,    0.0922,    1.1000),
         4: ('CB'  , 'CT'  ,   -0.0277,    1.9080),
         5: ('HB3' , 'H1'  ,    0.0680,    1.3870),
         6: ('HB2' , 'H1'  ,    0.0680,    1.3870),
         7: ('SG'  , 'S'   ,   -0.0984,    2.0000),
         9: ('N'   , 'N3'  ,    0.2069,    1.8240),
        10: ('H3'  , 'H'   ,    0.1815,    0.6000),
        11: ('H2'  , 'H'   ,    0.1815,    0.6000),
        12: ('H1'  , 'H'   ,    0.1815,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)S<7>S<7>)C<9>([O-]<10>)=O<11>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.1318,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0938,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.1934,    1.9080),
         5: ('HB3' , 'H1'  ,    0.1228,    1.3870),
         6: ('HB2' , 'H1'  ,    0.1228,    1.3870),
         7: ('SG'  , 'S'   ,   -0.0529,    2.0000),
         9: ('C'   , 'C'   ,    0.7618,    1.9080),
        10: ('OXT' , 'O2'  ,   -0.8041,    1.6612),
        11: ('O'   , 'O2'  ,   -0.8041,    1.6612),
      },
   ),
],
'CYX': [
   ( # disulfide bonded
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)S<7>S<7>)C<9>=O<10>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,    0.0429,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0766,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0790,    1.9080),
         5: ('HB3' , 'H1'  ,    0.0910,    1.3870),
         6: ('HB2' , 'H1'  ,    0.0910,    1.3870),
         7: ('SG'  , 'S'   ,   -0.1081,    2.0000),
         9: ('C'   , 'C'   ,    0.5973,    1.9080),
        10: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)S<7>S<7>)[N@+]<9>([H]<10>)([H]<11>)[H]<12>',
      {
         0: ('C'   , 'C'   ,    0.6123,    1.9080),
         1: ('O'   , 'O'   ,   -0.5713,    1.6612),
         2: ('CA'  , 'CT'  ,    0.1055,    1.9080),
         3: ('HA'  , 'HP'  ,    0.0922,    1.1000),
         4: ('CB'  , 'CT'  ,   -0.0277,    1.9080),
         5: ('HB3' , 'H1'  ,    0.0680,    1.3870),
         6: ('HB2' , 'H1'  ,    0.0680,    1.3870),
         7: ('SG'  , 'S'   ,   -0.0984,    2.0000),
         9: ('N'   , 'N3'  ,    0.2069,    1.8240),
        10: ('H3'  , 'H'   ,    0.1815,    0.6000),
        11: ('H2'  , 'H'   ,    0.1815,    0.6000),
        12: ('H1'  , 'H'   ,    0.1815,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)S<7>S<7>)C<9>([O-]<10>)=O<11>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.1318,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0938,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.1934,    1.9080),
         5: ('HB3' , 'H1'  ,    0.1228,    1.3870),
         6: ('HB2' , 'H1'  ,    0.1228,    1.3870),
         7: ('SG'  , 'S'   ,   -0.0529,    2.0000),
         9: ('C'   , 'C'   ,    0.7618,    1.9080),
        10: ('OXT' , 'O2'  ,   -0.8041,    1.6612),
        11: ('O'   , 'O2'  ,   -0.8041,    1.6612),
      },
   ),
],
'GLN': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)C<10>(=O<11>)N<12>([H]<13>)[H]<14>)C<15>=O<16>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.0031,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0850,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0036,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0171,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0171,    1.4870),
         7: ('CG'  , 'CT'  ,   -0.0645,    1.9080),
         8: ('HG3' , 'HC'  ,    0.0352,    1.4870),
         9: ('HG2' , 'HC'  ,    0.0352,    1.4870),
        10: ('CD'  , 'C'   ,    0.6951,    1.9080),
        11: ('OE1' , 'O'   ,   -0.6086,    1.6612),
        12: ('NE2' , 'N'   ,   -0.9407,    1.8240),
        13: ('HE22', 'H'   ,    0.4251,    0.6000),
        14: ('HE21', 'H'   ,    0.4251,    0.6000),
        15: ('C'   , 'C'   ,    0.5973,    1.9080),
        16: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)C<10>(=O<11>)N<12>([H]<13>)[H]<14>)[N@+]<15>([H]<16>)([H]<17>)[H]<18>',
      {
         0: ('C'   , 'C'   ,    0.6123,    1.9080),
         1: ('O'   , 'O'   ,   -0.5713,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0536,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1015,    1.1000),
         4: ('CB'  , 'CT'  ,    0.0651,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0050,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0050,    1.4870),
         7: ('CG'  , 'CT'  ,   -0.0903,    1.9080),
         8: ('HG3' , 'HC'  ,    0.0331,    1.4870),
         9: ('HG2' , 'HC'  ,    0.0331,    1.4870),
        10: ('CD'  , 'C'   ,    0.7354,    1.9080),
        11: ('OE1' , 'O'   ,   -0.6133,    1.6612),
        12: ('NE2' , 'N'   ,   -1.0031,    1.8240),
        13: ('HE22', 'H'   ,    0.4429,    0.6000),
        14: ('HE21', 'H'   ,    0.4429,    0.6000),
        15: ('N'   , 'N3'  ,    0.1493,    1.8240),
        16: ('H3'  , 'H'   ,    0.1996,    0.6000),
        17: ('H2'  , 'H'   ,    0.1996,    0.6000),
        18: ('H1'  , 'H'   ,    0.1996,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)C<10>(=O<11>)N<12>([H]<13>)[H]<14>)C<15>([O-]<16>)=O<17>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2248,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1232,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0664,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0452,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0452,    1.4870),
         7: ('CG'  , 'CT'  ,   -0.0210,    1.9080),
         8: ('HG3' , 'HC'  ,    0.0203,    1.4870),
         9: ('HG2' , 'HC'  ,    0.0203,    1.4870),
        10: ('CD'  , 'C'   ,    0.7093,    1.9080),
        11: ('OE1' , 'O'   ,   -0.6098,    1.6612),
        12: ('NE2' , 'N'   ,   -0.9574,    1.8240),
        13: ('HE22', 'H'   ,    0.4304,    0.6000),
        14: ('HE21', 'H'   ,    0.4304,    0.6000),
        15: ('C'   , 'C'   ,    0.7775,    1.9080),
        16: ('OXT' , 'O2'  ,   -0.8042,    1.6612),
        17: ('O'   , 'O2'  ,   -0.8042,    1.6612),
      },
   ),
],
'GLU': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)C<10>([O-]<11>)=O<12>)C<13>=O<14>',
      {
         0: ('N'   , 'N'   ,   -0.5163,    1.8240),
         1: ('H'   , 'H'   ,    0.2936,    0.6000),
         2: ('CA'  , 'CT'  ,    0.0397,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1105,    1.3870),
         4: ('CB'  , 'CT'  ,    0.0560,    1.9080),
         5: ('HB3' , 'HC'  ,   -0.0173,    1.4870),
         6: ('HB2' , 'HC'  ,   -0.0173,    1.4870),
         7: ('CG'  , 'CT'  ,    0.0136,    1.9080),
         8: ('HG3' , 'HC'  ,   -0.0425,    1.4870),
         9: ('HG2' , 'HC'  ,   -0.0425,    1.4870),
        10: ('CD'  , 'C'   ,    0.8054,    1.9080),
        11: ('OE2' , 'O2'  ,   -0.8188,    1.6612),
        12: ('OE1' , 'O2'  ,   -0.8188,    1.6612),
        13: ('C'   , 'C'   ,    0.5366,    1.9080),
        14: ('O'   , 'O'   ,   -0.5819,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)C<10>([O-]<11>)=O<12>)[N@+]<13>([H]<14>)([H]<15>)[H]<16>',
      {
         0: ('C'   , 'C'   ,    0.5621,    1.9080),
         1: ('O'   , 'O'   ,   -0.5889,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0588,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1202,    1.1000),
         4: ('CB'  , 'CT'  ,    0.0909,    1.9080),
         5: ('HB3' , 'HC'  ,   -0.0232,    1.4870),
         6: ('HB2' , 'HC'  ,   -0.0232,    1.4870),
         7: ('CG'  , 'CT'  ,   -0.0236,    1.9080),
         8: ('HG3' , 'HC'  ,   -0.0315,    1.4870),
         9: ('HG2' , 'HC'  ,   -0.0315,    1.4870),
        10: ('CD'  , 'C'   ,    0.8087,    1.9080),
        11: ('OE2' , 'O2'  ,   -0.8189,    1.6612),
        12: ('OE1' , 'O2'  ,   -0.8189,    1.6612),
        13: ('N'   , 'N3'  ,    0.0017,    1.8240),
        14: ('H3'  , 'H'   ,    0.2391,    0.6000),
        15: ('H2'  , 'H'   ,    0.2391,    0.6000),
        16: ('H1'  , 'H'   ,    0.2391,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)C<10>([O-]<11>)=O<12>)C<13>([O-]<14>)=O<15>',
      {
         0: ('N'   , 'N'   ,   -0.5192,    1.8240),
         1: ('H'   , 'H'   ,    0.3055,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2059,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1399,    1.3870),
         4: ('CB'  , 'CT'  ,    0.0071,    1.9080),
         5: ('HB3' , 'HC'  ,   -0.0078,    1.4870),
         6: ('HB2' , 'HC'  ,   -0.0078,    1.4870),
         7: ('CG'  , 'CT'  ,    0.0675,    1.9080),
         8: ('HG3' , 'HC'  ,   -0.0548,    1.4870),
         9: ('HG2' , 'HC'  ,   -0.0548,    1.4870),
        10: ('CD'  , 'C'   ,    0.8183,    1.9080),
        11: ('OE2' , 'O2'  ,   -0.8220,    1.6612),
        12: ('OE1' , 'O2'  ,   -0.8220,    1.6612),
        13: ('C'   , 'C'   ,    0.7420,    1.9080),
        14: ('OXT' , 'O2'  ,   -0.7930,    1.6612),
        15: ('O'   , 'O2'  ,   -0.7930,    1.6612),
      },
   ),
],
'GLY': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([H]<4>)C<5>=O<6>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.0252,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0698,    1.3870),
         4: ('HA3' , 'H1'  ,    0.0698,    1.3870),
         5: ('C'   , 'C'   ,    0.5973,    1.9080),
         6: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([H]<4>)[N@+]<5>([H]<6>)([H]<7>)[H]<8>',
      {
         0: ('C'   , 'C'   ,    0.6163,    1.9080),
         1: ('O'   , 'O'   ,   -0.5722,    1.6612),
         2: ('CA'  , 'CT'  ,   -0.0100,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0895,    1.1000),
         4: ('HA3' , 'H1'  ,    0.0895,    1.1000),
         5: ('N'   , 'N'   ,    0.2943,    1.8240),
         6: ('H2'  , 'H'   ,    0.1642,    0.6000),
         7: ('H1'  , 'H'   ,    0.1642,    0.6000),
         8: ('H3'  , 'H'   ,    0.1642,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([H]<4>)C<5>([O-]<6>)=O<7>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2493,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1056,    1.3870),
         4: ('HA3' , 'H1'  ,    0.1056,    1.3870),
         5: ('C'   , 'C'   ,    0.7231,    1.9080),
         6: ('OXT' , 'O2'  ,   -0.7855,    1.6612),
         7: ('O'   , 'O'   ,   -0.7855,    1.6612),
      },
   ),
],
'HIS': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1N<8>=C<9>([H]<10>)N<11>([H]<12>)C<13>=1[H]<14>)C<15>=O<16>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.0581,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1360,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0074,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0367,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0367,    1.4870),
         7: ('CG'  , 'CC'  ,    0.1868,    1.9080),
         8: ('ND1' , 'NB'  ,   -0.5432,    1.8240),
         9: ('CE1' , 'CR'  ,    0.1635,    1.9080),
        10: ('HE1' , 'H5'  ,    0.1435,    1.3590),
        11: ('NE2' , 'NA'  ,   -0.2795,    1.8240),
        12: ('HE2' , 'H'   ,    0.3339,    0.6000),
        13: ('CD2' , 'CW'  ,   -0.2207,    1.9080),
        14: ('HD2' , 'H4'  ,    0.1862,    1.4090),
        15: ('C'   , 'C'   ,    0.5973,    1.9080),
        16: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1N<8>=C<9>([H]<10>)N<11>([H]<12>)C<13>=1[H]<14>)[N@+]<15>([H]<16>)([H]<17>)[H]<18>',
      {
         0: ('C'   , 'C'   ,    0.6123,    1.9080),
         1: ('O'   , 'O'   ,   -0.5713,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0236,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1380,    1.1000),
         4: ('CB'  , 'CT'  ,    0.0489,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0223,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0223,    1.4870),
         7: ('CG'  , 'CC'  ,    0.1740,    1.9080),
         8: ('ND1' , 'NB'  ,   -0.5579,    1.8240),
         9: ('CE1' , 'CR'  ,    0.1804,    1.9080),
        10: ('HE1' , 'H5'  ,    0.1397,    1.3590),
        11: ('NE2' , 'NA'  ,   -0.2781,    1.8240),
        12: ('HE2' , 'H'   ,    0.3324,    0.6000),
        13: ('CD2' , 'CW'  ,   -0.2349,    1.9080),
        14: ('HD2' , 'H4'  ,    0.1963,    1.4090),
        15: ('N'   , 'N3'  ,    0.1472,    1.8240),
        16: ('H3'  , 'H'   ,    0.2016,    0.6000),
        17: ('H2'  , 'H'   ,    0.2016,    0.6000),
        18: ('H1'  , 'H'   ,    0.2016,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1N<8>=C<9>([H]<10>)N<11>([H]<12>)C<13>=1[H]<14>)C<15>([O-]<16>)=O<17>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2699,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1650,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.1068,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0620,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0620,    1.4870),
         7: ('CG'  , 'CC'  ,    0.2724,    1.9080),
         8: ('ND1' , 'NB'  ,   -0.5517,    1.8240),
         9: ('CE1' , 'CR'  ,    0.1558,    1.9080),
        10: ('HE1' , 'H5'  ,    0.1448,    1.3590),
        11: ('NE2' , 'NA'  ,   -0.2670,    1.8240),
        12: ('HE2' , 'H'   ,    0.3319,    0.6000),
        13: ('CD2' , 'CW'  ,   -0.2588,    1.9080),
        14: ('HD2' , 'H4'  ,    0.1957,    1.4090),
        15: ('C'   , 'C'   ,    0.7916,    1.9080),
        16: ('OXT' , 'O2'  ,   -0.8065,    1.6612),
        17: ('O'   , 'O2'  ,   -0.8065,    1.6612),
      },
   ),
],
'HIP': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1[N+]<8>([H]<9>)=C<10>([H]<11>)N<12>([H]<13>)C<14>=1[H]<15>)C<16>=O<17>',
      {
         0: ('N'   , 'N'   ,   -0.3479,    1.8240),
         1: ('H'   , 'H'   ,    0.2747,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.1354,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1212,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0414,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0810,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0810,    1.4870),
         7: ('CG'  , 'CC'  ,   -0.0012,    1.9080),
         8: ('ND1' , 'NA'  ,   -0.1513,    1.8240),
         9: ('HD1' , 'H'   ,    0.3866,    0.6000),
        10: ('CE1' , 'CR'  ,   -0.0170,    1.9080),
        11: ('HE1' , 'H5'  ,    0.2681,    1.3590),
        12: ('NE2' , 'NA'  ,   -0.1718,    1.8240),
        13: ('HE2' , 'H'   ,    0.3911,    0.6000),
        14: ('CD2' , 'CW'  ,   -0.1141,    1.9080),
        15: ('HD2' , 'H4'  ,    0.2317,    1.4090),
        16: ('C'   , 'C'   ,    0.7341,    1.9080),
        17: ('O'   , 'O'   ,   -0.5894,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1[N+]<8>([H]<9>)=C<10>([H]<11>)N<12>([H]<13>)C<14>=1[H]<15>)[N@+]<16>([H]<17>)([H]<18>)[H]<19>',
      {
         0: ('C'   , 'C'   ,    0.7214,    1.9080),
         1: ('O'   , 'O'   ,   -0.6013,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0581,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1047,    1.1000),
         4: ('CB'  , 'CT'  ,    0.0484,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0531,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0531,    1.4870),
         7: ('CG'  , 'CC'  ,   -0.0236,    1.9080),
         8: ('ND1' , 'NA'  ,   -0.1510,    1.8240),
         9: ('HD1' , 'H'   ,    0.3821,    0.6000),
        10: ('CE1' , 'CR'  ,   -0.0011,    1.9080),
        11: ('HE1' , 'H5'  ,    0.2645,    1.3590),
        12: ('NE2' , 'NA'  ,   -0.1739,    1.8240),
        13: ('HE2' , 'H'   ,    0.3921,    0.6000),
        14: ('CD2' , 'CW'  ,   -0.1433,    1.9080),
        15: ('HD2' , 'H4'  ,    0.2495,    1.4090),
        16: ('N'   , 'N3'  ,    0.2560,    1.8240),
        17: ('H3'  , 'H'   ,    0.1704,    0.6000),
        18: ('H2'  , 'H'   ,    0.1704,    0.6000),
        19: ('H1'  , 'H'   ,    0.1704,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1[N+]<8>([H]<9>)=C<10>([H]<11>)N<12>([H]<13>)C<14>=1[H]<15>)C<16>([O-]<17>)=O<18>',
      {
         0: ('N'   , 'N'   ,   -0.3481,    1.8240),
         1: ('H'   , 'H'   ,    0.2764,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.1445,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1115,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0800,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0868,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0868,    1.4870),
         7: ('CG'  , 'CC'  ,    0.0298,    1.9080),
         8: ('ND1' , 'NA'  ,   -0.1501,    1.8240),
         9: ('HD1' , 'H'   ,    0.3883,    0.6000),
        10: ('CE1' , 'CR'  ,   -0.0251,    1.9080),
        11: ('HE1' , 'H5'  ,    0.2694,    1.3590),
        12: ('NE2' , 'NA'  ,   -0.1683,    1.8240),
        13: ('HE2' , 'H'   ,    0.3913,    0.6000),
        14: ('CD2' , 'CW'  ,   -0.1256,    1.9080),
        15: ('HD2' , 'H4'  ,    0.2336,    1.4090),
        16: ('C'   , 'C'   ,    0.8032,    1.9080),
        17: ('OXT' , 'O2'  ,   -0.8177,    1.6612),
        18: ('O'   , 'O2'  ,   -0.8177,    1.6612),
      },
   ),
],
'HID': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1N<8>([H]<9>)C<10>([H]<11>)=N<12>C<13>=1[H]<14>)C<15>=O<16>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,    0.0188,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0881,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0462,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0402,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0402,    1.4870),
         7: ('CG'  , 'CC'  ,   -0.0266,    1.9080),
         8: ('ND1' , 'NA'  ,   -0.3811,    1.8240),
         9: ('HD1' , 'H'   ,    0.3649,    0.6000),
        10: ('CE1' , 'CR'  ,    0.2057,    1.9080),
        11: ('HE1' , 'H5'  ,    0.1392,    1.3590),
        12: ('NE2' , 'NB'  ,   -0.5727,    1.8240),
        13: ('CD2' , 'CV'  ,    0.1292,    1.9080),
        14: ('HD2' , 'H4'  ,    0.1147,    1.4090),
        15: ('C'   , 'C'   ,    0.5973,    1.9080),
        16: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1N<8>([H]<9>)C<10>([H]<11>)=N<12>C<13>=1[H]<14>)[N@+]<15>([H]<16>)([H]<17>)[H]<18>',
      {
         0: ('C'   , 'C'   ,    0.6123,    1.9080),
         1: ('O'   , 'O'   ,   -0.5713,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0964,    1.9080),
         3: ('HA'  , 'HP'  ,    0.0958,    1.1000),
         4: ('CB'  , 'CT'  ,    0.0259,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0209,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0209,    1.4870),
         7: ('CG'  , 'CC'  ,   -0.0399,    1.9080),
         8: ('ND1' , 'NA'  ,   -0.3819,    1.8240),
         9: ('HD1' , 'H'   ,    0.3632,    0.6000),
        10: ('CE1' , 'CR'  ,    0.2127,    1.9080),
        11: ('HE1' , 'H5'  ,    0.1385,    1.3590),
        12: ('NE2' , 'NB'  ,   -0.5711,    1.8240),
        13: ('CD2' , 'CV'  ,    0.1046,    1.9080),
        14: ('HD2' , 'H4'  ,    0.1299,    1.4090),
        15: ('N'   , 'N3'  ,    0.1542,    1.8240),
        16: ('H3'  , 'H'   ,    0.1963,    0.6000),
        17: ('H2'  , 'H'   ,    0.1963,    0.6000),
        18: ('H1'  , 'H'   ,    0.1963,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1N<8>([H]<9>)C<10>([H]<11>)=N<12>C<13>=1[H]<14>)C<15>([O-]<16>)=O<17>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.1739,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1100,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.1046,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0565,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0565,    1.4870),
         7: ('CG'  , 'CC'  ,    0.0293,    1.9080),
         8: ('ND1' , 'NA'  ,   -0.3892,    1.8240),
         9: ('HD1' , 'H'   ,    0.3755,    0.6000),
        10: ('CE1' , 'CR'  ,    0.1925,    1.9080),
        11: ('HE1' , 'H5'  ,    0.1418,    1.3590),
        12: ('NE2' , 'NB'  ,   -0.5629,    1.8240),
        13: ('CD2' , 'CV'  ,    0.1001,    1.9080),
        14: ('HD2' , 'H4'  ,    0.1241,    1.4090),
        15: ('C'   , 'C'   ,    0.7615,    1.9080),
        16: ('OXT' , 'O2'  ,   -0.8016,    1.6612),
        17: ('O'   , 'O2'  ,   -0.8016,    1.6612),
      },
   ),
],
'ILE': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([C@]<6>([H]<7>)([H]<8>)[H]<9>)[C@@]<10>([H]<11>)([H]<12>)[C@]<13>([H]<14>)([H]<15>)[H]<16>)C<17>=O<18>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.0597,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0869,    1.3870),
         4: ('CB'  , 'CT'  ,    0.1303,    1.9080),
         5: ('HB'  , 'HC'  ,    0.0187,    1.4870),
         6: ('CG2' , 'CT'  ,   -0.3204,    1.9080),
         7: ('HG23', 'HC'  ,    0.0882,    1.4870),
         8: ('HG22', 'HC'  ,    0.0882,    1.4870),
         9: ('HG21', 'HC'  ,    0.0882,    1.4870),
        10: ('CG1' , 'CT'  ,   -0.0430,    1.9080),
        11: ('HG13', 'HC'  ,    0.0236,    1.4870),
        12: ('HG12', 'HC'  ,    0.0236,    1.4870),
        13: ('CD1' , 'CT'  ,   -0.0660,    1.9080),
        14: ('HD13', 'HC'  ,    0.0186,    1.4870),
        15: ('HD12', 'HC'  ,    0.0186,    1.4870),
        16: ('HD11', 'HC'  ,    0.0186,    1.4870),
        17: ('C'   , 'C'   ,    0.5973,    1.9080),
        18: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([C@]<6>([H]<7>)([H]<8>)[H]<9>)[C@@]<10>([H]<11>)([H]<12>)[C@]<13>([H]<14>)([H]<15>)[H]<16>)[N@+]<17>([H]<18>)([H]<19>)[H]<20>',
      {
         0: ('C'   , 'C'   ,    0.6123,    1.9080),
         1: ('O'   , 'O'   ,   -0.5713,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0257,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1031,    1.1000),
         4: ('CB'  , 'CT'  ,    0.1885,    1.9080),
         5: ('HB'  , 'HC'  ,    0.0213,    1.4870),
         6: ('CG2' , 'CT'  ,   -0.3720,    1.9080),
         7: ('HG23', 'HC'  ,    0.0947,    1.4870),
         8: ('HG22', 'HC'  ,    0.0947,    1.4870),
         9: ('HG21', 'HC'  ,    0.0947,    1.4870),
        10: ('CG1' , 'CT'  ,   -0.0387,    1.9080),
        11: ('HG13', 'HC'  ,    0.0201,    1.4870),
        12: ('HG12', 'HC'  ,    0.0201,    1.4870),
        13: ('CD1' , 'CT'  ,   -0.0908,    1.9080),
        14: ('HD13', 'HC'  ,    0.0226,    1.4870),
        15: ('HD12', 'HC'  ,    0.0226,    1.4870),
        16: ('HD11', 'HC'  ,    0.0226,    1.4870),
        17: ('N'   , 'N3'  ,    0.0311,    1.8240),
        18: ('H3'  , 'H'   ,    0.2329,    0.6000),
        19: ('H2'  , 'H'   ,    0.2329,    0.6000),
        20: ('H1'  , 'H'   ,    0.2329,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([C@]<6>([H]<7>)([H]<8>)[H]<9>)[C@@]<10>([H]<11>)([H]<12>)[C@]<13>([H]<14>)([H]<15>)[H]<16>)C<17>([O-]<18>)=O<19>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.3100,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1375,    1.3870),
         4: ('CB'  , 'CT'  ,    0.0363,    1.9080),
         5: ('HB'  , 'HC'  ,    0.0766,    1.4870),
         6: ('CG2' , 'CT'  ,   -0.3498,    1.9080),
         7: ('HG23', 'HC'  ,    0.1021,    1.4870),
         8: ('HG22', 'HC'  ,    0.1021,    1.4870),
         9: ('HG21', 'HC'  ,    0.1021,    1.4870),
        10: ('CG1' , 'CT'  ,   -0.0323,    1.9080),
        11: ('HG13', 'HC'  ,    0.0321,    1.4870),
        12: ('HG12', 'HC'  ,    0.0321,    1.4870),
        13: ('CD1' , 'CT'  ,   -0.0699,    1.9080),
        14: ('HD13', 'HC'  ,    0.0196,    1.4870),
        15: ('HD12', 'HC'  ,    0.0196,    1.4870),
        16: ('HD11', 'HC'  ,    0.0196,    1.4870),
        17: ('C'   , 'C'   ,    0.8343,    1.9080),
        18: ('OXT' , 'O2'  ,   -0.8190,    1.6612),
        19: ('O'   , 'O2'  ,   -0.8190,    1.6612),
      },
   ),
],
'LEU': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@]<7>([H]<8>)([C@]<9>([H]<10>)([H]<11>)[H]<12>)[C@]<13>([H]<14>)([H]<15>)[H]<16>)C<17>=O<18>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.0518,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0922,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.1102,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0457,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0457,    1.4870),
         7: ('CG'  , 'CT'  ,    0.3531,    1.9080),
         8: ('HG'  , 'HC'  ,   -0.0361,    1.4870),
         9: ('CD2' , 'CT'  ,   -0.4121,    1.9080),
        10: ('HD23', 'HC'  ,    0.1000,    1.4870),
        11: ('HD22', 'HC'  ,    0.1000,    1.4870),
        12: ('HD21', 'HC'  ,    0.1000,    1.4870),
        13: ('CD1' , 'CT'  ,   -0.4121,    1.9080),
        14: ('HD13', 'HC'  ,    0.1000,    1.4870),
        15: ('HD12', 'HC'  ,    0.1000,    1.4870),
        16: ('HD11', 'HC'  ,    0.1000,    1.4870),
        17: ('C'   , 'C'   ,    0.5973,    1.9080),
        18: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@]<7>([H]<8>)([C@]<9>([H]<10>)([H]<11>)[H]<12>)[C@]<13>([H]<14>)([H]<15>)[H]<16>)[N@+]<17>([H]<18>)([H]<19>)[H]<20>',
      {
         0: ('C'   , 'C'   ,    0.6123,    1.9080),
         1: ('O'   , 'O'   ,   -0.5713,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0104,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1053,    1.1000),
         4: ('CB'  , 'CT'  ,   -0.0244,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0256,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0256,    1.4870),
         7: ('CG'  , 'CT'  ,    0.3421,    1.9080),
         8: ('HG'  , 'HC'  ,   -0.0380,    1.4870),
         9: ('CD2' , 'CT'  ,   -0.4104,    1.9080),
        10: ('HD23', 'HC'  ,    0.0980,    1.4870),
        11: ('HD22', 'HC'  ,    0.0980,    1.4870),
        12: ('HD21', 'HC'  ,    0.0980,    1.4870),
        13: ('CD1' , 'CT'  ,   -0.4106,    1.9080),
        14: ('HD13', 'HC'  ,    0.0980,    1.4870),
        15: ('HD12', 'HC'  ,    0.0980,    1.4870),
        16: ('HD11', 'HC'  ,    0.0980,    1.4870),
        17: ('N'   , 'N3'  ,    0.1010,    1.8240),
        18: ('H3'  , 'H'   ,    0.2148,    0.6000),
        19: ('H2'  , 'H'   ,    0.2148,    0.6000),
        20: ('H1'  , 'H'   ,    0.2148,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@]<7>([H]<8>)([C@]<9>([H]<10>)([H]<11>)[H]<12>)[C@]<13>([H]<14>)([H]<15>)[H]<16>)C<17>([O-]<18>)=O<19>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2847,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1346,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.2469,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0974,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0974,    1.4870),
         7: ('CG'  , 'CT'  ,    0.3706,    1.9080),
         8: ('HG'  , 'HC'  ,   -0.0374,    1.4870),
         9: ('CD2' , 'CT'  ,   -0.4163,    1.9080),
        10: ('HD23', 'HC'  ,    0.1038,    1.4870),
        11: ('HD22', 'HC'  ,    0.1038,    1.4870),
        12: ('HD21', 'HC'  ,    0.1038,    1.4870),
        13: ('CD1' , 'CT'  ,   -0.4163,    1.9080),
        14: ('HD13', 'HC'  ,    0.1038,    1.4870),
        15: ('HD12', 'HC'  ,    0.1038,    1.4870),
        16: ('HD11', 'HC'  ,    0.1038,    1.4870),
        17: ('C'   , 'C'   ,    0.8326,    1.9080),
        18: ('OXT' , 'O2'  ,   -0.8199,    1.6612),
        19: ('O'   , 'O2'  ,   -0.8199,    1.6612),
      },
   ),
],
'LYS': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)[C@@]<10>([H]<11>)([H]<12>)[C@@]<13>([H]<14>)([H]<15>)[N@+]<16>([H]<17>)([H]<18>)[H]<19>)C<20>=O<21>',
      {
         0: ('N'   , 'N'   ,   -0.3479,    1.8240),
         1: ('H'   , 'H'   ,    0.2747,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2400,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1426,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0094,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0362,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0362,    1.4870),
         7: ('CG'  , 'CT'  ,    0.0187,    1.9080),
         8: ('HG3' , 'HC'  ,    0.0103,    1.4870),
         9: ('HG2' , 'HC'  ,    0.0103,    1.4870),
        10: ('CD'  , 'CT'  ,   -0.0479,    1.9080),
        11: ('HD3' , 'HC'  ,    0.0621,    1.4870),
        12: ('HD2' , 'HC'  ,    0.0621,    1.4870),
        13: ('CE'  , 'CT'  ,   -0.0143,    1.9080),
        14: ('HE3' , 'HP'  ,    0.1135,    1.1000),
        15: ('HE2' , 'HP'  ,    0.1135,    1.1000),
        16: ('NZ'  , 'N3'  ,   -0.3854,    1.8240),
        17: ('HZ2' , 'H'   ,    0.3400,    0.6000),
        18: ('HZ1' , 'H'   ,    0.3400,    0.6000),
        19: ('HZ3' , 'H'   ,    0.3400,    0.6000),
        20: ('C'   , 'C'   ,    0.7341,    1.9080),
        21: ('O'   , 'O'   ,   -0.5894,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)[C@@]<10>([H]<11>)([H]<12>)[C@@]<13>([H]<14>)([H]<15>)[N@+]<16>([H]<17>)([H]<18>)[H]<19>)[N@+]<20>([H]<21>)([H]<22>)[H]<23>',
      {
         0: ('C'   , 'C'   ,    0.7214,    1.9080),
         1: ('O'   , 'O'   ,   -0.6013,    1.6612),
         2: ('CA'  , 'CT'  ,   -0.0015,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1180,    1.1000),
         4: ('CB'  , 'CT'  ,    0.0212,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0283,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0283,    1.4870),
         7: ('CG'  , 'CT'  ,   -0.0048,    1.9080),
         8: ('HG3' , 'HC'  ,    0.0121,    1.4870),
         9: ('HG2' , 'HC'  ,    0.0121,    1.4870),
        10: ('CD'  , 'CT'  ,   -0.0608,    1.9080),
        11: ('HD3' , 'HC'  ,    0.0633,    1.4870),
        12: ('HD2' , 'HC'  ,    0.0633,    1.4870),
        13: ('CE'  , 'CT'  ,   -0.0181,    1.9080),
        14: ('HE3' , 'HP'  ,    0.1171,    1.1000),
        15: ('HE2' , 'HP'  ,    0.1171,    1.1000),
        16: ('NZ'  , 'N3'  ,   -0.3764,    1.8240),
        17: ('HZ2' , 'H'   ,    0.3382,    0.6000),
        18: ('HZ1' , 'H'   ,    0.3382,    0.6000),
        19: ('HZ3' , 'H'   ,    0.3382,    0.6000),
        20: ('N'   , 'N3'  ,    0.0966,    1.8240),
        21: ('H3'  , 'H'   ,    0.2165,    0.6000),
        22: ('H2'  , 'H'   ,    0.2165,    0.6000),
        23: ('H1'  , 'H'   ,    0.2165,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)[C@@]<10>([H]<11>)([H]<12>)[C@@]<13>([H]<14>)([H]<15>)[N@+]<16>([H]<17>)([H]<18>)[H]<19>)C<20>([O-]<21>)=O<22>',
      {
         0: ('N'   , 'N'   ,   -0.3481,    1.8240),
         1: ('H'   , 'H'   ,    0.2764,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2903,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1438,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0538,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0482,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0482,    1.4870),
         7: ('CG'  , 'CT'  ,    0.0227,    1.9080),
         8: ('HG3' , 'HC'  ,    0.0134,    1.4870),
         9: ('HG2' , 'HC'  ,    0.0134,    1.4870),
        10: ('CD'  , 'CT'  ,   -0.0392,    1.9080),
        11: ('HD3' , 'HC'  ,    0.0611,    1.4870),
        12: ('HD2' , 'HC'  ,    0.0611,    1.4870),
        13: ('CE'  , 'CT'  ,   -0.0176,    1.9080),
        14: ('HE3' , 'HP'  ,    0.1121,    1.1000),
        15: ('HE2' , 'HP'  ,    0.1121,    1.1000),
        16: ('NZ'  , 'N3'  ,   -0.3741,    1.8240),
        17: ('HZ2' , 'H'   ,    0.3374,    0.6000),
        18: ('HZ1' , 'H'   ,    0.3374,    0.6000),
        19: ('HZ3' , 'H'   ,    0.3374,    0.6000),
        20: ('C'   , 'C'   ,    0.8488,    1.9080),
        21: ('OXT' , 'O2'  ,   -0.8252,    1.6612),
        22: ('O'   , 'O2'  ,   -0.8252,    1.6612),
      },
   ),
],
'MET': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)S<10>[C@]<11>([H]<12>)([H]<13>)[H]<14>)C<15>=O<16>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.0237,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0880,    1.3870),
         4: ('CB'  , 'CT'  ,    0.0342,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0241,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0241,    1.4870),
         7: ('CG'  , 'CT'  ,    0.0018,    1.9080),
         8: ('HG3' , 'H1'  ,    0.0440,    1.3870),
         9: ('HG2' , 'H1'  ,    0.0440,    1.3870),
        10: ('SD'  , 'S'   ,   -0.2737,    2.0000),
        11: ('CE'  , 'CT'  ,   -0.0536,    1.9080),
        12: ('HE3' , 'H1'  ,    0.0684,    1.3870),
        13: ('HE2' , 'H1'  ,    0.0684,    1.3870),
        14: ('HE1' , 'H1'  ,    0.0684,    1.3870),
        15: ('C'   , 'C'   ,    0.5973,    1.9080),
        16: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)S<10>[C@]<11>([H]<12>)([H]<13>)[H]<14>)[N@+]<15>([H]<16>)([H]<17>)[H]<18>',
      {
         0: ('C'   , 'C'   ,    0.6123,    1.9080),
         1: ('O'   , 'O'   ,   -0.5713,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0221,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1116,    1.1000),
         4: ('CB'  , 'CT'  ,    0.0865,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0125,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0125,    1.4870),
         7: ('CG'  , 'CT'  ,    0.0334,    1.9080),
         8: ('HG3' , 'H1'  ,    0.0292,    1.3870),
         9: ('HG2' , 'H1'  ,    0.0292,    1.3870),
        10: ('SD'  , 'S'   ,   -0.2774,    2.0000),
        11: ('CE'  , 'CT'  ,   -0.0341,    1.9080),
        12: ('HE3' , 'H1'  ,    0.0597,    1.3870),
        13: ('HE2' , 'H1'  ,    0.0597,    1.3870),
        14: ('HE1' , 'H1'  ,    0.0597,    1.3870),
        15: ('N'   , 'N3'  ,    0.1592,    1.8240),
        16: ('H3'  , 'H'   ,    0.1984,    0.6000),
        17: ('H2'  , 'H'   ,    0.1984,    0.6000),
        18: ('H1'  , 'H'   ,    0.1984,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)S<10>[C@]<11>([H]<12>)([H]<13>)[H]<14>)C<15>([O-]<16>)=O<17>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2597,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1277,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0236,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0480,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0480,    1.4870),
         7: ('CG'  , 'CT'  ,    0.0492,    1.9080),
         8: ('HG3' , 'H1'  ,    0.0317,    1.3870),
         9: ('HG2' , 'H1'  ,    0.0317,    1.3870),
        10: ('SD'  , 'S'   ,   -0.2692,    2.0000),
        11: ('CE'  , 'CT'  ,   -0.0376,    1.9080),
        12: ('HE3' , 'H1'  ,    0.0625,    1.3870),
        13: ('HE2' , 'H1'  ,    0.0625,    1.3870),
        14: ('HE1' , 'H1'  ,    0.0625,    1.3870),
        15: ('C'   , 'C'   ,    0.8013,    1.9080),
        16: ('OXT' , 'O2'  ,   -0.8105,    1.6612),
        17: ('O'   , 'O2'  ,   -0.8105,    1.6612),
      },
   ),
],
'PHE': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1C<8>([H]<9>)=C<10>([H]<11>)C<12>([H]<13>)=C<14>([H]<15>)C<16>=1[H]<17>)C<18>=O<19>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.0024,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0978,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0343,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0295,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0295,    1.4870),
         7: ('CG'  , 'CA'  ,    0.0118,    1.9080),
         8: ('CD2' , 'CA'  ,   -0.1256,    1.9080),
         9: ('HD2' , 'HA'  ,    0.1330,    1.4590),
        10: ('CE2' , 'CA'  ,   -0.1704,    1.9080),
        11: ('HE2' , 'HA'  ,    0.1430,    1.4590),
        12: ('CZ'  , 'CA'  ,   -0.1072,    1.9080),
        13: ('HZ'  , 'HA'  ,    0.1297,    1.4590),
        14: ('CE1' , 'CA'  ,   -0.1704,    1.9080),
        15: ('HE1' , 'HA'  ,    0.1430,    1.4590),
        16: ('CD1' , 'CA'  ,   -0.1256,    1.9080),
        17: ('HD1' , 'HA'  ,    0.1330,    1.4590),
        18: ('C'   , 'C'   ,    0.5973,    1.9080),
        19: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1C<8>([H]<9>)=C<10>([H]<11>)C<12>([H]<13>)=C<14>([H]<15>)C<16>=1[H]<17>)[N@+]<18>([H]<19>)([H]<20>)[H]<21>',
      {
         0: ('C'   , 'C'   ,    0.6123,    1.9080),
         1: ('O'   , 'O'   ,   -0.5713,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0733,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1041,    1.1000),
         4: ('CB'  , 'CT'  ,    0.0330,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0104,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0104,    1.4870),
         7: ('CG'  , 'CA'  ,    0.0031,    1.9080),
         8: ('CD2' , 'CA'  ,   -0.1391,    1.9080),
         9: ('HD2' , 'HA'  ,    0.1374,    1.4590),
        10: ('CE2' , 'CA'  ,   -0.1603,    1.9080),
        11: ('HE2' , 'HA'  ,    0.1433,    1.4590),
        12: ('CZ'  , 'CA'  ,   -0.1208,    1.9080),
        13: ('HZ'  , 'HA'  ,    0.1329,    1.4590),
        14: ('CE1' , 'CA'  ,   -0.1602,    1.9080),
        15: ('HE1' , 'HA'  ,    0.1433,    1.4590),
        16: ('CD1' , 'CA'  ,   -0.1392,    1.9080),
        17: ('HD1' , 'HA'  ,    0.1374,    1.4590),
        18: ('N'   , 'N3'  ,    0.1737,    1.8240),
        19: ('H3'  , 'H'   ,    0.1921,    0.6000),
        20: ('H2'  , 'H'   ,    0.1921,    0.6000),
        21: ('H1'  , 'H'   ,    0.1921,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1C<8>([H]<9>)=C<10>([H]<11>)C<12>([H]<13>)=C<14>([H]<15>)C<16>=1[H]<17>)C<18>([O-]<19>)=O<20>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.1825,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1098,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0959,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0443,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0443,    1.4870),
         7: ('CG'  , 'CA'  ,    0.0552,    1.9080),
         8: ('CD2' , 'CA'  ,   -0.1300,    1.9080),
         9: ('HD2' , 'HA'  ,    0.1408,    1.4590),
        10: ('CE2' , 'CA'  ,   -0.1847,    1.9080),
        11: ('HE2' , 'HA'  ,    0.1461,    1.4590),
        12: ('CZ'  , 'CA'  ,   -0.0944,    1.9080),
        13: ('HZ'  , 'HA'  ,    0.1280,    1.4590),
        14: ('CE1' , 'CA'  ,   -0.1847,    1.9080),
        15: ('HE1' , 'HA'  ,    0.1461,    1.4590),
        16: ('CD1' , 'CA'  ,   -0.1300,    1.9080),
        17: ('HD1' , 'HA'  ,    0.1408,    1.4590),
        18: ('C'   , 'C'   ,    0.7660,    1.9080),
        19: ('OXT' , 'O2'  ,   -0.8026,    1.6612),
        20: ('O'   , 'O2'  ,   -0.8026,    1.6612),
      },
   ),
],
'PRO': [
   (
      'N<0>1[C@]<1>([H]<2>)([H]<3>)[C@]<4>([H]<5>)([H]<6>)[C@]<7>([H]<8>)([H]<9>)[C@@]<10>1([H]<11>)C<12>=O<13>',
      {
         0: ('N'   , 'N'   ,   -0.2548,    1.8240),
         1: ('CD'  , 'CT'  ,    0.0192,    1.9080),
         2: ('HD3' , 'H1'  ,    0.0391,    1.3870),
         3: ('HD2' , 'H1'  ,    0.0391,    1.3870),
         4: ('CG'  , 'CT'  ,    0.0189,    1.9080),
         5: ('HG3' , 'HC'  ,    0.0213,    1.4870),
         6: ('HG2' , 'HC'  ,    0.0213,    1.4870),
         7: ('CB'  , 'CT'  ,   -0.0070,    1.9080),
         8: ('HB3' , 'HC'  ,    0.0253,    1.4870),
         9: ('HB2' , 'HC'  ,    0.0253,    1.4870),
        10: ('CA'  , 'CT'  ,   -0.0266,    1.9080),
        11: ('HA'  , 'H1'  ,    0.0641,    1.3870),
        12: ('C'   , 'C'   ,    0.5896,    1.9080),
        13: ('O'   , 'O'   ,   -0.5748,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>1([H]<3>)[C@@]<4>([H]<5>)([H]<6>)[C@@]<7>([H]<8>)([H]<9>)[C@@]<10>([H]<11>)([H]<12>)[N@@+]<13>1([H]<14>)[H]<15>',
      {
         0: ('C'   , 'C'   ,    0.5260,    1.9080),
         1: ('O'   , 'O'   ,   -0.5000,    1.6612),
         2: ('CA'  , 'CT'  ,    0.1000,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1000,    1.1000),
         4: ('CB'  , 'CT'  ,   -0.1150,    1.9080),
         5: ('HB3' , 'HC'  ,    0.1000,    1.4870),
         6: ('HB2' , 'HC'  ,    0.1000,    1.4870),
         7: ('CG'  , 'CT'  ,   -0.1210,    1.9080),
         8: ('HG3' , 'HC'  ,    0.1000,    1.4870),
         9: ('HG2' , 'HC'  ,    0.1000,    1.4870),
        10: ('CD'  , 'CT'  ,   -0.0120,    1.9080),
        11: ('HD3' , 'H1'  ,    0.1000,    1.1000),
        12: ('HD2' , 'H1'  ,    0.1000,    1.1000),
        13: ('N'   , 'N3'  ,   -0.2020,    1.8240),
        14: ('H3'  , 'H'   ,    0.3120,    0.6000),
        15: ('H2'  , 'H'   ,    0.3120,    0.6000),
      },
   ),
   (
      'N<0>1[C@]<1>([H]<2>)([H]<3>)[C@]<4>([H]<5>)([H]<6>)[C@]<7>([H]<8>)([H]<9>)[C@@]<10>1([H]<11>)C<12>([O-]<13>)=O<14>',
      {
         0: ('N'   , 'N'   ,   -0.2802,    1.8240),
         1: ('CD'  , 'CT'  ,    0.0434,    1.9080),
         2: ('HD3' , 'H1'  ,    0.0331,    1.3870),
         3: ('HD2' , 'H1'  ,    0.0331,    1.3870),
         4: ('CG'  , 'CT'  ,    0.0466,    1.9080),
         5: ('HG3' , 'HC'  ,    0.0172,    1.4870),
         6: ('HG2' , 'HC'  ,    0.0172,    1.4870),
         7: ('CB'  , 'CT'  ,   -0.0543,    1.9080),
         8: ('HB3' , 'HC'  ,    0.0381,    1.4870),
         9: ('HB2' , 'HC'  ,    0.0381,    1.4870),
        10: ('CA'  , 'CT'  ,   -0.1336,    1.9080),
        11: ('HA'  , 'H1'  ,    0.0776,    1.3870),
        12: ('C'   , 'C'   ,    0.6631,    1.9080),
        13: ('OXT' , 'O2'  ,   -0.7697,    1.6612),
        14: ('O'   , 'O2'  ,   -0.7697,    1.6612),
      },
   ),
],
'SER': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)O<7>[H]<8>)C<9>=O<10>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.0249,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0843,    1.3870),
         4: ('CB'  , 'CT'  ,    0.2117,    1.9080),
         5: ('HB3' , 'H1'  ,    0.0352,    1.3870),
         6: ('HB2' , 'H1'  ,    0.0352,    1.3870),
         7: ('OG'  , 'OH'  ,   -0.6546,    1.7210),
         8: ('HG'  , 'HO'  ,    0.4275,    0.0000),
         9: ('C'   , 'C'   ,    0.5973,    1.9080),
        10: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)O<7>[H]<8>)[N@+]<9>([H]<10>)([H]<11>)[H]<12>',
      {
         0: ('C'   , 'C'   ,    0.6163,    1.9080),
         1: ('O'   , 'O'   ,   -0.5722,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0567,    1.9080),
         3: ('HA'  , 'HP'  ,    0.0782,    1.1000),
         4: ('CB'  , 'CT'  ,    0.2596,    1.9080),
         5: ('HB3' , 'H1'  ,    0.0273,    1.3870),
         6: ('HB2' , 'H1'  ,    0.0273,    1.3870),
         7: ('OG'  , 'OH'  ,   -0.6714,    1.7210),
         8: ('HG'  , 'HO'  ,    0.4239,    0.0000),
         9: ('N'   , 'N3'  ,    0.1849,    1.8240),
        10: ('H3'  , 'H'   ,    0.1898,    0.6000),
        11: ('H2'  , 'H'   ,    0.1898,    0.6000),
        12: ('H1'  , 'H'   ,    0.1898,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)O<7>[H]<8>)C<9>([O-]<10>)=O<11>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2722,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1304,    1.3870),
         4: ('CB'  , 'CT'  ,    0.1123,    1.9080),
         5: ('HB3' , 'H1'  ,    0.0813,    1.3870),
         6: ('HB2' , 'H1'  ,    0.0813,    1.3870),
         7: ('OG'  , 'OH'  ,   -0.6514,    1.7210),
         8: ('HG'  , 'HO'  ,    0.4474,    0.0000),
         9: ('C'   , 'C'   ,    0.8113,    1.9080),
        10: ('OXT' , 'O2'  ,   -0.8132,    1.6612),
        11: ('O'   , 'O2'  ,   -0.8132,    1.6612),
      },
   ),
],
'THR': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@]<4>([H]<5>)(O<6>[H]<7>)[C@]<8>([H]<9>)([H]<10>)[H]<11>)C<12>=O<13>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.0389,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1007,    1.3870),
         4: ('CB'  , 'CT'  ,    0.3654,    1.9080),
         5: ('HB'  , 'H1'  ,    0.0043,    1.3870),
         6: ('OG1' , 'OH'  ,   -0.6761,    1.7210),
         7: ('HG1' , 'HO'  ,    0.4102,    0.0000),
         8: ('CG2' , 'CT'  ,   -0.2438,    1.9080),
         9: ('HG23', 'HC'  ,    0.0642,    1.4870),
        10: ('HG22', 'HC'  ,    0.0642,    1.4870),
        11: ('HG21', 'HC'  ,    0.0642,    1.4870),
        12: ('C'   , 'C'   ,    0.5973,    1.9080),
        13: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@]<4>([H]<5>)(O<6>[H]<7>)[C@]<8>([H]<9>)([H]<10>)[H]<11>)[N@+]<12>([H]<13>)([H]<14>)[H]<15>',
      {
         0: ('C'   , 'C'   ,    0.6163,    1.9080),
         1: ('O'   , 'O'   ,   -0.5722,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0034,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1087,    1.1000),
         4: ('CB'  , 'CT'  ,    0.4514,    1.9080),
         5: ('HB'  , 'H1'  ,   -0.0323,    1.3870),
         6: ('OG1' , 'OH'  ,   -0.6764,    1.7210),
         7: ('HG1' , 'HO'  ,    0.4070,    0.0000),
         8: ('CG2' , 'CT'  ,   -0.2554,    1.9080),
         9: ('HG23', 'HC'  ,    0.0627,    1.4870),
        10: ('HG22', 'HC'  ,    0.0627,    1.4870),
        11: ('HG21', 'HC'  ,    0.0627,    1.4870),
        12: ('N'   , 'N3'  ,    0.1812,    1.8240),
        13: ('H3'  , 'H'   ,    0.1934,    0.6000),
        14: ('H2'  , 'H'   ,    0.1934,    0.6000),
        15: ('H1'  , 'H'   ,    0.1934,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@]<4>([H]<5>)(O<6>[H]<7>)[C@]<8>([H]<9>)([H]<10>)[H]<11>)C<12>([O-]<13>)=O<14>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2420,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1207,    1.3870),
         4: ('CB'  , 'CT'  ,    0.3025,    1.9080),
         5: ('HB'  , 'H1'  ,    0.0078,    1.3870),
         6: ('OG1' , 'OH'  ,   -0.6496,    1.7210),
         7: ('HG1' , 'HO'  ,    0.4119,    0.0000),
         8: ('CG2' , 'CT'  ,   -0.1853,    1.9080),
         9: ('HG23', 'HC'  ,    0.0586,    1.4870),
        10: ('HG22', 'HC'  ,    0.0586,    1.4870),
        11: ('HG21', 'HC'  ,    0.0586,    1.4870),
        12: ('C'   , 'C'   ,    0.7810,    1.9080),
        13: ('OXT' , 'O2'  ,   -0.8044,    1.6612),
        14: ('O'   , 'O2'  ,   -0.8044,    1.6612),
      },
   ),
],
'TRP': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>1=C<8>([H]<9>)N<10>([H]<11>)C<12>=2C<13>([H]<14>)=C<15>([H]<16>)C<17>([H]<18>)=C<19>([H]<20>)C<21>1=2)C<22>=O<23>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.0275,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1123,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0050,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0339,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0339,    1.4870),
         7: ('CG'  , 'C*'  ,   -0.1415,    1.9080),
         8: ('CD1' , 'CW'  ,   -0.1638,    1.9080),
         9: ('HD1' , 'H4'  ,    0.2062,    1.4090),
        10: ('NE1' , 'NA'  ,   -0.3418,    1.8240),
        11: ('HE1' , 'H'   ,    0.3412,    0.6000),
        12: ('CE2' , 'CN'  ,    0.1380,    1.9080),
        13: ('CZ2' , 'CA'  ,   -0.2601,    1.9080),
        14: ('HZ2' , 'HA'  ,    0.1572,    1.4590),
        15: ('CH2' , 'CA'  ,   -0.1134,    1.9080),
        16: ('HH2' , 'HA'  ,    0.1417,    1.4590),
        17: ('CZ3' , 'CA'  ,   -0.1972,    1.9080),
        18: ('HZ3' , 'HA'  ,    0.1447,    1.4590),
        19: ('CE3' , 'CA'  ,   -0.2387,    1.9080),
        20: ('HE3' , 'HA'  ,    0.1700,    1.4590),
        21: ('CD2' , 'CB'  ,    0.1243,    1.9080),
        22: ('C'   , 'C'   ,    0.5973,    1.9080),
        23: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>1=C<8>([H]<9>)N<10>([H]<11>)C<12>=2C<13>([H]<14>)=C<15>([H]<16>)C<17>([H]<18>)=C<19>([H]<20>)C<21>1=2)[N@+]<22>([H]<23>)([H]<24>)[H]<25>',
      {
         0: ('C'   , 'C'   ,    0.6123,    1.9080),
         1: ('O'   , 'O'   ,   -0.5713,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0421,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1162,    1.1000),
         4: ('CB'  , 'CT'  ,    0.0543,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0222,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0222,    1.4870),
         7: ('CG'  , 'C*'  ,   -0.1654,    1.9080),
         8: ('CD1' , 'CW'  ,   -0.1788,    1.9080),
         9: ('HD1' , 'H4'  ,    0.2195,    1.4090),
        10: ('NE1' , 'NA'  ,   -0.3444,    1.8240),
        11: ('HE1' , 'H'   ,    0.3412,    0.6000),
        12: ('CE2' , 'CN'  ,    0.1575,    1.9080),
        13: ('CZ2' , 'CA'  ,   -0.2710,    1.9080),
        14: ('HZ2' , 'HA'  ,    0.1589,    1.4590),
        15: ('CH2' , 'CA'  ,   -0.1080,    1.9080),
        16: ('HH2' , 'HA'  ,    0.1411,    1.4590),
        17: ('CZ3' , 'CA'  ,   -0.2034,    1.9080),
        18: ('HZ3' , 'HA'  ,    0.1458,    1.4590),
        19: ('CE3' , 'CA'  ,   -0.2265,    1.9080),
        20: ('HE3' , 'HA'  ,    0.1646,    1.4590),
        21: ('CD2' , 'CB'  ,    0.1132,    1.9080),
        22: ('N'   , 'N3'  ,    0.1913,    1.8240),
        23: ('H3'  , 'H'   ,    0.1888,    0.6000),
        24: ('H2'  , 'H'   ,    0.1888,    0.6000),
        25: ('H1'  , 'H'   ,    0.1888,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>1=C<8>([H]<9>)N<10>([H]<11>)C<12>=2C<13>([H]<14>)=C<15>([H]<16>)C<17>([H]<18>)=C<19>([H]<20>)C<21>1=2)C<22>([O-]<23>)=O<24>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2084,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1272,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0742,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0497,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0497,    1.4870),
         7: ('CG'  , 'C*'  ,   -0.0796,    1.9080),
         8: ('CD1' , 'CW'  ,   -0.1808,    1.9080),
         9: ('HD1' , 'H4'  ,    0.2043,    1.4090),
        10: ('NE1' , 'NA'  ,   -0.3316,    1.8240),
        11: ('HE1' , 'H'   ,    0.3413,    0.6000),
        12: ('CE2' , 'CN'  ,    0.1222,    1.9080),
        13: ('CZ2' , 'CA'  ,   -0.2594,    1.9080),
        14: ('HZ2' , 'HA'  ,    0.1567,    1.4590),
        15: ('CH2' , 'CA'  ,   -0.1020,    1.9080),
        16: ('HH2' , 'HA'  ,    0.1401,    1.4590),
        17: ('CZ3' , 'CA'  ,   -0.2287,    1.9080),
        18: ('HZ3' , 'HA'  ,    0.1507,    1.4590),
        19: ('CE3' , 'CA'  ,   -0.1837,    1.9080),
        20: ('HE3' , 'HA'  ,    0.1491,    1.4590),
        21: ('CD2' , 'CB'  ,    0.1078,    1.9080),
        22: ('C'   , 'C'   ,    0.7658,    1.9080),
        23: ('OXT' , 'O2'  ,   -0.8011,    1.6612),
        24: ('O'   , 'O2'  ,   -0.8011,    1.6612),
      },
   ),
],
'TYR': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1C<8>([H]<9>)=C<10>([H]<11>)C<12>(O<13>[H]<14>)=C<15>([H]<16>)C<17>=1[H]<18>)C<19>=O<20>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.0014,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0876,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0152,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0295,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0295,    1.4870),
         7: ('CG'  , 'CA'  ,   -0.0011,    1.9080),
         8: ('CD2' , 'CA'  ,   -0.1906,    1.9080),
         9: ('HD2' , 'HA'  ,    0.1699,    1.4590),
        10: ('CE2' , 'CA'  ,   -0.2341,    1.9080),
        11: ('HE2' , 'HA'  ,    0.1656,    1.4590),
        12: ('CZ'  , 'CA'  ,    0.3226,    1.9080),
        13: ('OH'  , 'OH'  ,   -0.5579,    1.7210),
        14: ('HH'  , 'HO'  ,    0.3992,    0.0000),
        15: ('CE1' , 'CA'  ,   -0.2341,    1.9080),
        16: ('HE1' , 'HA'  ,    0.1656,    1.4590),
        17: ('CD1' , 'CA'  ,   -0.1906,    1.9080),
        18: ('HD1' , 'HA'  ,    0.1699,    1.4590),
        19: ('C'   , 'C'   ,    0.5973,    1.9080),
        20: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1C<8>([H]<9>)=C<10>([H]<11>)C<12>(O<13>[H]<14>)=C<15>([H]<16>)C<17>=1[H]<18>)[N@+]<19>([H]<20>)([H]<21>)[H]<22>',
      {
         0: ('C'   , 'C'   ,    0.6123,    1.9080),
         1: ('O'   , 'O'   ,   -0.5713,    1.6612),
         2: ('CA'  , 'CT'  ,    0.0570,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0983,    1.1000),
         4: ('CB'  , 'CT'  ,    0.0659,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0102,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0102,    1.4870),
         7: ('CG'  , 'CA'  ,   -0.0205,    1.9080),
         8: ('CD2' , 'CA'  ,   -0.2002,    1.9080),
         9: ('HD2' , 'HA'  ,    0.1720,    1.4590),
        10: ('CE2' , 'CA'  ,   -0.2239,    1.9080),
        11: ('HE2' , 'HA'  ,    0.1650,    1.4590),
        12: ('CZ'  , 'CA'  ,    0.3139,    1.9080),
        13: ('OH'  , 'OH'  ,   -0.5578,    1.7210),
        14: ('HH'  , 'HO'  ,    0.4001,    0.0000),
        15: ('CE1' , 'CA'  ,   -0.2239,    1.9080),
        16: ('HE1' , 'HA'  ,    0.1650,    1.4590),
        17: ('CD1' , 'CA'  ,   -0.2002,    1.9080),
        18: ('HD1' , 'HA'  ,    0.1720,    1.4590),
        19: ('N'   , 'N'   ,    0.1940,    1.8240),
        20: ('H3'  , 'H'   ,    0.1873,    0.6000),
        21: ('H2'  , 'H'   ,    0.1873,    0.6000),
        22: ('H1'  , 'H'   ,    0.1873,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@@]<4>([H]<5>)([H]<6>)C<7>=1C<8>([H]<9>)=C<10>([H]<11>)C<12>(O<13>[H]<14>)=C<15>([H]<16>)C<17>=1[H]<18>)C<19>([O-]<20>)=O<21>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.2015,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1092,    1.3870),
         4: ('CB'  , 'CT'  ,   -0.0752,    1.9080),
         5: ('HB3' , 'HC'  ,    0.0490,    1.4870),
         6: ('HB2' , 'HC'  ,    0.0490,    1.4870),
         7: ('CG'  , 'CA'  ,    0.0243,    1.9080),
         8: ('CD2' , 'CA'  ,   -0.1922,    1.9080),
         9: ('HD2' , 'HA'  ,    0.1780,    1.4590),
        10: ('CE2' , 'CA'  ,   -0.2458,    1.9080),
        11: ('HE2' , 'HA'  ,    0.1673,    1.4590),
        12: ('CZ'  , 'CA'  ,    0.3395,    1.9080),
        13: ('OH'  , 'OH'  ,   -0.5643,    1.7210),
        14: ('HH'  , 'HO'  ,    0.4017,    0.0000),
        15: ('CE1' , 'CA'  ,   -0.2458,    1.9080),
        16: ('HE1' , 'HA'  ,    0.1673,    1.4590),
        17: ('CD1' , 'CA'  ,   -0.1922,    1.9080),
        18: ('HD1' , 'HA'  ,    0.1780,    1.4590),
        19: ('C'   , 'C'   ,    0.7817,    1.9080),
        20: ('OXT' , 'O2'  ,   -0.8070,    1.6612),
        21: ('O'   , 'O'   ,   -0.8070,    1.6612),
      },
   ),
],
'VAL': [
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@]<4>([H]<5>)([C@]<6>([H]<7>)([H]<8>)[H]<9>)[C@]<10>([H]<11>)([H]<12>)[H]<13>)C<14>=O<15>',
      {
         0: ('N'   , 'N'   ,   -0.4157,    1.8240),
         1: ('H'   , 'H'   ,    0.2719,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.0875,    1.9080),
         3: ('HA'  , 'H1'  ,    0.0969,    1.3870),
         4: ('CB'  , 'CT'  ,    0.2985,    1.9080),
         5: ('HB'  , 'HC'  ,   -0.0297,    1.4870),
         6: ('CG2' , 'CT'  ,   -0.3192,    1.9080),
         7: ('HG23', 'HC'  ,    0.0791,    1.4870),
         8: ('HG22', 'HC'  ,    0.0791,    1.4870),
         9: ('HG21', 'HC'  ,    0.0791,    1.4870),
        10: ('CG1' , 'CT'  ,   -0.3192,    1.9080),
        11: ('HG13', 'HC'  ,    0.0791,    1.4870),
        12: ('HG12', 'HC'  ,    0.0791,    1.4870),
        13: ('HG11', 'HC'  ,    0.0791,    1.4870),
        14: ('C'   , 'C'   ,    0.5973,    1.9080),
        15: ('O'   , 'O'   ,   -0.5679,    1.6612),
      },
   ),
   (
      'C<0>(=O<1>)[C@]<2>([H]<3>)([C@]<4>([H]<5>)([C@]<6>([H]<7>)([H]<8>)[H]<9>)[C@]<10>([H]<11>)([H]<12>)[H]<13>)[N@+]<14>([H]<15>)([H]<16>)[H]<17>',
      {
         0: ('C'   , 'C'   ,    0.6163,    1.9080),
         1: ('O'   , 'O'   ,   -0.5722,    1.6612),
         2: ('CA'  , 'CT'  ,   -0.0054,    1.9080),
         3: ('HA'  , 'HP'  ,    0.1093,    1.1000),
         4: ('CB'  , 'CT'  ,    0.3196,    1.9080),
         5: ('HB'  , 'HC'  ,   -0.0221,    1.4870),
         6: ('CG2' , 'CT'  ,   -0.3129,    1.9080),
         7: ('HG23', 'HC'  ,    0.0735,    1.4870),
         8: ('HG22', 'HC'  ,    0.0735,    1.4870),
         9: ('HG21', 'HC'  ,    0.0735,    1.4870),
        10: ('CG1' , 'CT'  ,   -0.3129,    1.9080),
        11: ('HG13', 'HC'  ,    0.0735,    1.4870),
        12: ('HG12', 'HC'  ,    0.0735,    1.4870),
        13: ('HG11', 'HC'  ,    0.0735,    1.4870),
        14: ('N'   , 'N3'  ,    0.0577,    1.8240),
        15: ('H3'  , 'H'   ,    0.2272,    0.6000),
        16: ('H2'  , 'H'   ,    0.2272,    0.6000),
        17: ('H1'  , 'H'   ,    0.2272,    0.6000),
      },
   ),
   (
      'N<0>([H]<1>)[C@@]<2>([H]<3>)([C@]<4>([H]<5>)([C@]<6>([H]<7>)([H]<8>)[H]<9>)[C@]<10>([H]<11>)([H]<12>)[H]<13>)C<14>([O-]<15>)=O<16>',
      {
         0: ('N'   , 'N'   ,   -0.3821,    1.8240),
         1: ('H'   , 'H'   ,    0.2681,    0.6000),
         2: ('CA'  , 'CT'  ,   -0.3438,    1.9080),
         3: ('HA'  , 'H1'  ,    0.1438,    1.3870),
         4: ('CB'  , 'CT'  ,    0.1940,    1.9080),
         5: ('HB'  , 'HC'  ,    0.0308,    1.4870),
         6: ('CG2' , 'CT'  ,   -0.3064,    1.9080),
         7: ('HG23', 'HC'  ,    0.0836,    1.4870),
         8: ('HG22', 'HC'  ,    0.0836,    1.4870),
         9: ('HG21', 'HC'  ,    0.0836,    1.4870),
        10: ('CG1' , 'CT'  ,   -0.3064,    1.9080),
        11: ('HG13', 'HC'  ,    0.0836,    1.4870),
        12: ('HG12', 'HC'  ,    0.0836,    1.4870),
        13: ('HG11', 'HC'  ,    0.0836,    1.4870),
        14: ('C'   , 'C'   ,    0.8350,    1.9080),
        15: ('OXT' , 'O2'  ,   -0.8173,    1.6612),
        16: ('O'   , 'O2'  ,   -0.8173,    1.6612),
      },
   ),
],
'WAT': [
   (
      'O<0>([H]<1>)[H]<2>',
      {
         0: ('O'   , 'OW'  ,   -0.8340,    1.6612),
         1: ('H1'  , 'HW'  ,    0.4170,    0.0000),
         2: ('H2'  , 'HW'  ,    0.4170,    0.0000),
      },
   ),
],
'HOH': [
   (
      'O<0>([H]<1>)[H]<2>',
      {
         0: ('O'   , 'OW'  ,   -0.8340,    1.6612),
         1: ('H1'  , 'HW'  ,    0.4170,    0.0000),
         2: ('H2'  , 'HW'  ,    0.4170,    0.0000),
      },
   ),
],
'TIP': [
   (
      'O<0>([H]<1>)[H]<2>',
      {
         0: ('O'   , 'OW'  ,   -0.8340,    1.6612),
         1: ('H1'  , 'HW'  ,    0.4170,    0.0000),
         2: ('H2'  , 'HW'  ,    0.4170,    0.0000),
      },
   ),
],

}

# also want commong residues like PTyr, PSer,

# missing neutrals GLUH/GLUN,GLH, ASPH/ASH/ASPN, LYSN, ARGN

for alias in (
    ( 'HIE', 'HIS'), # default HIS is HISE
    ( 'HISE', 'HIS'),
    ( 'HISD', 'HID'),
    ( 'HISP', 'HIP'),
    ( 'GLUM', 'GLU'), # default -1
    ( 'ASPM', 'ASP'), # default -1
    ( 'LYSP', 'LYS'), # default +1
    ( 'ARGP', 'ARG'), # default +1
    ):
    amber99_dict[alias[0]] = amber99_dict[alias[1]]
