\name{RichardsonLucyDeconvolutionImageFilter}
\alias{RichardsonLucyDeconvolutionImageFilter}
\title{RichardsonLucyDeconvolutionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Deconvolve an image using the Richardson-Lucy deconvolution algorithm.
RichardsonLucyDeconvolutionImageFilter}
\details{
This filter implements the Richardson-Lucy deconvolution algorithm as
defined in Bertero M and Boccacci P, "Introduction to Inverse
Problems in Imaging", 1998. The algorithm assumes that the input
image has been formed by a linear shift-invariant system with a known
kernel.
The Richardson-Lucy algorithm assumes that noise in the image follows
a Poisson distribution and that the distribution for each pixel is
independent of the other pixels.
This code was adapted from the Insight Journal contribution:
"Deconvolution: infrastructure and reference algorithms" by Gaetan
Lehmann https://www.insight-journal.org/browse/publication/753
Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France
Cory Quammen, The University of North Carolina at Chapel Hill
See:
IterativeDeconvolutionImageFilter
LandweberDeconvolutionImageFilter
ProjectedLandweberDeconvolutionImageFilter
RichardsonLucyDeconvolution for the procedural interface
itk::RichardsonLucyDeconvolutionImageFilter for the Doxygen on the original ITK class.
RichardsonLucyDeconvolutionImageFilter}
%C++ includes: sitkRichardsonLucyDeconvolutionImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{
Execute the filter on the input images
}
\item{BoundaryConditionType GetBoundaryCondition() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNormalize() const:}{}
\item{int GetNumberOfIterations() const:}{
Get the number of iterations.
}
\item{OutputRegionModeType GetOutputRegionMode() const:}{}
\item{Self NormalizeOff():}{}
\item{Self NormalizeOn():}{
Set the value of Normalize to true or false respectfully.
}
\item{ RichardsonLucyDeconvolutionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetBoundaryCondition(BoundaryConditionType BoundaryCondition):}{}
\item{Self SetNormalize(bool Normalize):}{
Normalize the output image by the sum of the kernel components
}
\item{Self SetNumberOfIterations(int NumberOfIterations):}{
Set the number of iterations.
}
\item{Self SetOutputRegionMode(OutputRegionModeType OutputRegionMode):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~RichardsonLucyDeconvolutionImageFilter():}{
Destructor
}
}
}
